/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.expr.node;

import org.seasar.doma.internal.expr.node.ExpressionLocation;
import org.seasar.doma.internal.expr.node.ExpressionNode;
import org.seasar.doma.internal.expr.node.ExpressionNodeVisitor;
import org.seasar.doma.internal.util.AssertionUtil;

public class LiteralNode
implements ExpressionNode {
    protected final ExpressionLocation location;
    protected final String expression;
    protected final Object value;
    protected final Class<?> valueClass;

    public <T> LiteralNode(ExpressionLocation location, String expression, T value, Class<T> valueClass) {
        AssertionUtil.assertNotNull((Object)location, (Object)expression, valueClass);
        this.location = location;
        this.expression = expression;
        this.value = value;
        this.valueClass = valueClass;
    }

    public Object getValue() {
        return this.value;
    }

    public Class<?> getValueClass() {
        return this.valueClass;
    }

    @Override
    public <R, P> R accept(ExpressionNodeVisitor<R, P> visitor, P p) {
        return visitor.visitLiteralNode(this, p);
    }

    @Override
    public ExpressionLocation getLocation() {
        return this.location;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    public String toString() {
        return this.expression;
    }
}

