/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import java.lang.reflect.Method;
import org.seasar.doma.internal.jdbc.entity.AbstractPostDeleteContext;
import org.seasar.doma.internal.jdbc.entity.AbstractPreDeleteContext;
import org.seasar.doma.internal.jdbc.query.BatchDeleteQuery;
import org.seasar.doma.internal.jdbc.query.SqlFileBatchModifyQuery;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.VersionPropertyType;

public class SqlFileBatchDeleteQuery<E>
extends SqlFileBatchModifyQuery<E>
implements BatchDeleteQuery {
    protected EntityHandler entityHandler;
    protected boolean versionIgnored;
    protected boolean optimisticLockExceptionSuppressed;

    public SqlFileBatchDeleteQuery(Class<E> elementClass) {
        super(elementClass, SqlKind.BATCH_DELETE);
    }

    @Override
    public void prepare() {
        super.prepare();
        int size = this.elements.size();
        if (size == 0) {
            return;
        }
        this.executable = true;
        this.sqlExecutionSkipCause = null;
        this.currentEntity = this.elements.get(0);
        this.preDelete();
        this.prepareSqlFile();
        this.prepareOptions();
        this.prepareOptimisticLock();
        this.prepareSql();
        this.elements.set(0, this.currentEntity);
        for (int i = 1; i < size; ++i) {
            this.currentEntity = this.elements.get(i);
            this.preDelete();
            this.prepareSql();
            this.elements.set(i, this.currentEntity);
        }
        AssertionUtil.assertEquals(size, this.sqls.size());
    }

    protected void preDelete() {
        if (this.entityHandler != null) {
            this.entityHandler.preDelete();
        }
    }

    protected void prepareOptimisticLock() {
        if (this.entityHandler != null) {
            this.entityHandler.prepareOptimisticLock();
        }
    }

    @Override
    public void complete() {
        if (this.entityHandler != null) {
            int len = this.elements.size();
            for (int i = 0; i < len; ++i) {
                this.currentEntity = this.elements.get(i);
                this.entityHandler.postDelete();
                this.elements.set(i, this.currentEntity);
            }
        }
    }

    @Override
    public void setEntityType(EntityType<E> entityType) {
        this.entityHandler = new EntityHandler(entityType);
    }

    public void setVersionIgnored(boolean versionIgnored) {
        this.versionIgnored = versionIgnored;
    }

    public void setOptimisticLockExceptionSuppressed(boolean optimisticLockExceptionSuppressed) {
        this.optimisticLockExceptionSuppressed = optimisticLockExceptionSuppressed;
    }

    protected static class SqlFileBatchPostDeleteContext<E>
    extends AbstractPostDeleteContext<E> {
        public SqlFileBatchPostDeleteContext(EntityType<E> entityType, Method method, Config config) {
            super(entityType, method, config);
        }
    }

    protected static class SqlFileBatchPreDeleteContext<E>
    extends AbstractPreDeleteContext<E> {
        public SqlFileBatchPreDeleteContext(EntityType<E> entityType, Method method, Config config) {
            super(entityType, method, config);
        }
    }

    protected class EntityHandler {
        protected EntityType<E> entityType;
        protected VersionPropertyType<? super E, E, ?, ?> versionPropertyType;

        protected EntityHandler(EntityType<E> entityType) {
            AssertionUtil.assertNotNull(entityType);
            this.entityType = entityType;
            this.versionPropertyType = entityType.getVersionPropertyType();
        }

        protected void preDelete() {
            SqlFileBatchPreDeleteContext context = new SqlFileBatchPreDeleteContext(this.entityType, SqlFileBatchDeleteQuery.this.method, SqlFileBatchDeleteQuery.this.config);
            this.entityType.preDelete(SqlFileBatchDeleteQuery.this.currentEntity, context);
            if (context.getNewEntity() != null) {
                SqlFileBatchDeleteQuery.this.currentEntity = context.getNewEntity();
            }
        }

        protected void postDelete() {
            SqlFileBatchPostDeleteContext context = new SqlFileBatchPostDeleteContext(this.entityType, SqlFileBatchDeleteQuery.this.method, SqlFileBatchDeleteQuery.this.config);
            this.entityType.postDelete(SqlFileBatchDeleteQuery.this.currentEntity, context);
            if (context.getNewEntity() != null) {
                SqlFileBatchDeleteQuery.this.currentEntity = context.getNewEntity();
            }
        }

        protected void prepareOptimisticLock() {
            if (this.versionPropertyType != null && !SqlFileBatchDeleteQuery.this.versionIgnored && !SqlFileBatchDeleteQuery.this.optimisticLockExceptionSuppressed) {
                SqlFileBatchDeleteQuery.this.optimisticLockCheckRequired = true;
            }
        }
    }
}

