/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql.node;

import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.jdbc.sql.node.AbstractSqlNode;
import org.seasar.doma.internal.jdbc.sql.node.OtherNode;
import org.seasar.doma.internal.jdbc.sql.node.ParensNodeVisitor;
import org.seasar.doma.internal.jdbc.sql.node.SqlLocation;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.SqlNodeVisitor;

public class ParensNode
extends AbstractSqlNode {
    protected final SqlLocation location;
    protected boolean attachedWithBindVariable;
    protected boolean empty = true;
    protected OtherNode openedParensNode;
    protected OtherNode closedParensNode;

    public ParensNode(SqlLocation location) {
        AssertionUtil.assertNotNull(location);
        this.location = location;
        this.openedParensNode = OtherNode.of("(");
    }

    public boolean isAttachedWithBindVariable() {
        return this.attachedWithBindVariable;
    }

    public void setAttachedWithBindVariable(boolean attachedWithBindVariable) {
        this.attachedWithBindVariable = attachedWithBindVariable;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    public OtherNode getOpenedFragmentNode() {
        return this.openedParensNode;
    }

    public OtherNode getClosedFragmentNode() {
        return this.closedParensNode;
    }

    public SqlLocation getLocation() {
        return this.location;
    }

    public void close() {
        this.closedParensNode = OtherNode.of(")");
    }

    @Override
    public ParensNode copy() {
        ParensNode clone = new ParensNode(this.location);
        clone.attachedWithBindVariable = this.attachedWithBindVariable;
        if (this.openedParensNode != null) {
            clone.openedParensNode = this.openedParensNode.copy();
        }
        if (this.closedParensNode != null) {
            clone.closedParensNode = this.closedParensNode.copy();
        }
        for (SqlNode child : this.children) {
            clone.addNode(child.copy());
        }
        return clone;
    }

    @Override
    public <R, P> R accept(SqlNodeVisitor<R, P> visitor, P p) {
        if (visitor == null) {
            throw new DomaNullPointerException("visitor");
        }
        if (visitor instanceof ParensNodeVisitor) {
            ParensNodeVisitor v = (ParensNodeVisitor)visitor;
            return v.visitParensNode(this, p);
        }
        return visitor.visitUnknownNode(this, p);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        buf.append(this.getClass().getSimpleName());
        buf.append(" ");
        if (this.openedParensNode != null) {
            buf.append(this.openedParensNode);
        }
        for (SqlNode child : this.children) {
            buf.append(child);
        }
        if (this.closedParensNode != null) {
            buf.append(this.closedParensNode);
        }
        buf.append("]");
        return buf.toString();
    }
}

