/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.unit;

import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import org.junit.Assert;
import org.seasar.cubby.unit.MockServletContext;

class MockFilterConfig
implements FilterConfig {
    private final ServletContext servletContext;
    private final String filterName;
    private final Properties initParameters = new Properties();

    public MockFilterConfig(ServletContext servletContext) {
        this(servletContext, "");
    }

    public MockFilterConfig(ServletContext servletContext, String filterName) {
        this.servletContext = servletContext != null ? servletContext : new MockServletContext();
        this.filterName = filterName;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getInitParameter(String name) {
        Assert.assertNotNull((String)name, (Object)"Parameter name must not be null");
        return this.initParameters.getProperty(name);
    }

    public Enumeration getInitParameterNames() {
        return this.initParameters.keys();
    }
}

