/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.plugins.spring.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.seasar.cubby.converter.Converter;
import org.seasar.cubby.spi.impl.AbstractCachedConverterProvider;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringConverterProvider
extends AbstractCachedConverterProvider
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private boolean initialized = false;
    private final Class<Converter> converterClass = Converter.class;
    private final Set<Converter> converters = new LinkedHashSet<Converter>();

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void initialize() {
        String[] names;
        if (this.initialized) {
            return;
        }
        for (String name : names = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, this.converterClass)) {
            Converter converter = this.converterClass.cast(this.applicationContext.getBean(name, this.converterClass));
            this.converters.add(converter);
        }
        this.initialized = true;
    }

    public Collection<Converter> getConverters() {
        return Collections.unmodifiableCollection(this.converters);
    }
}

