/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.spi.impl;

import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.seasar.cubby.controller.RequestParser;
import org.seasar.cubby.controller.impl.DefaultRequestParser;
import org.seasar.cubby.internal.util.LogMessages;
import org.seasar.cubby.spi.RequestParserProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRequestParserProvider
implements RequestParserProvider {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRequestParserProvider.class);
    private final RequestParser defaultRequestParser = new DefaultRequestParser();

    @Override
    public Map<String, Object[]> getParameterMap(HttpServletRequest request) {
        RequestParser requestParser = this.findRequestParser(request);
        if (logger.isDebugEnabled()) {
            logger.debug(LogMessages.format("DCUB0016", requestParser));
        }
        Map<String, Object[]> parameterMap = requestParser.getParameterMap(request);
        return parameterMap;
    }

    protected RequestParser findRequestParser(HttpServletRequest request) {
        for (RequestParser requestParser : this.getRequestParsers()) {
            if (!requestParser.isParsable(request)) continue;
            return requestParser;
        }
        return this.defaultRequestParser;
    }

    protected abstract Collection<RequestParser> getRequestParsers();
}

