/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.functions.MathX;
import org.apache.poi.hssf.record.formula.functions.XYNumericFunction;

public class Sumx2my2
extends XYNumericFunction {
    public Eval evaluate(Eval[] operands, int srcCellRow, short srcCellCol) {
        ErrorEval retval = null;
        double[][] values = null;
        boolean checkLen = false;
        switch (operands.length) {
            default: {
                retval = ErrorEval.VALUE_INVALID;
                break;
            }
            case 2: {
                values = this.getValues(operands, srcCellRow, srcCellCol);
                if (values != null && values[0] != null && values[1] != null && values[0].length != 0 && values[1].length != 0 && values[0].length == values[1].length) break;
                retval = ErrorEval.VALUE_INVALID;
            }
        }
        if (retval == null) {
            double d = MathX.sumx2my2(values[0], values[1]);
            retval = Double.isNaN(d) || Double.isInfinite(d) ? ErrorEval.NUM_ERROR : new NumberEval(d);
        }
        return retval;
    }
}

