/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.unit;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.seasar.cubby.action.ActionContext;
import org.seasar.cubby.action.ActionResult;
import org.seasar.cubby.filter.CubbyFilter;
import org.seasar.cubby.internal.plugin.PluginManager;
import org.seasar.cubby.plugin.AbstractPlugin;
import org.seasar.cubby.plugin.ActionResultInvocation;
import org.seasar.cubby.plugin.Plugin;
import org.seasar.cubby.plugin.PluginRegistry;
import org.seasar.cubby.unit.MockFilterConfig;
import org.seasar.cubby.unit.MockServletContext;

public class CubbyRunner {
    private static PluginManager pluginManager = new PluginManager(PluginRegistry.getInstance());

    public static ActionResult processAction(HttpServletRequest request, HttpServletResponse response, Filter ... filters) throws Exception {
        MockServletContext servletContext = new MockServletContext();
        return CubbyRunner.processAction(servletContext, request, response, filters);
    }

    public static ActionResult processAction(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, Filter ... filters) throws Exception {
        return CubbyRunner.doProcess(false, servletContext, request, response, filters);
    }

    public static ActionResult processActionAndExecuteActionResult(HttpServletRequest request, HttpServletResponse response, Filter ... filters) throws Exception {
        MockServletContext servletContext = new MockServletContext();
        return CubbyRunner.processActionAndExecuteActionResult(servletContext, request, response, filters);
    }

    public static ActionResult processActionAndExecuteActionResult(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, Filter ... filters) throws Exception {
        return CubbyRunner.doProcess(true, servletContext, request, response, filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ActionResult doProcess(boolean executeActionResult, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, Filter ... filters) throws Exception {
        MockFilterConfig filterConfig = new MockFilterConfig(servletContext);
        for (Filter filter : filters) {
            filter.init((FilterConfig)filterConfig);
        }
        try {
            CubbyRunnerPlugin cubbyRunnerPlugin = new CubbyRunnerPlugin();
            PluginRegistry pluginRegistry = PluginRegistry.getInstance();
            pluginRegistry.register((Plugin)cubbyRunnerPlugin);
            pluginManager.init(servletContext);
            CubbyRunnerHttpServletRequestWrapper requestWrapper = new CubbyRunnerHttpServletRequestWrapper(request);
            ActionInvokeFilterChain chain = new ActionInvokeFilterChain(filters);
            chain.doFilter((ServletRequest)requestWrapper, (ServletResponse)response);
            ActionResult actionResult = cubbyRunnerPlugin.getActionResult();
            if (executeActionResult) {
                ActionContext actionContext = requestWrapper.getActionContext();
                actionResult.execute(actionContext, (HttpServletRequest)requestWrapper, response);
            }
            ActionResult actionResult2 = actionResult;
            return actionResult2;
        }
        finally {
            pluginManager.destroy();
            for (Filter filter : filters) {
                filter.destroy();
            }
        }
    }

    static class CubbyRunnerHttpServletRequestWrapper
    extends HttpServletRequestWrapper {
        private ActionContext actionContext;

        public CubbyRunnerHttpServletRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public void setAttribute(String name, Object o) {
            if ("org.seasar.cubby.actionContext".equals(name)) {
                this.actionContext = (ActionContext)o;
            }
            super.setAttribute(name, o);
        }

        public ActionContext getActionContext() {
            return this.actionContext;
        }
    }

    static class CubbyRunnerPlugin
    extends AbstractPlugin {
        private ActionResult actionResult;

        CubbyRunnerPlugin() {
        }

        public void invokeActionResult(ActionResultInvocation invocation) throws Exception {
            this.actionResult = invocation.getActionResult();
        }

        public ActionResult getActionResult() {
            return this.actionResult;
        }
    }

    static class ActionInvokeFilterChain
    implements FilterChain {
        private final Iterator<Filter> iterator;

        public ActionInvokeFilterChain(Filter ... filters) {
            this.iterator = Arrays.asList(filters).iterator();
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this.iterator.hasNext()) {
                Filter filter = this.iterator.next();
                filter.doFilter(request, response, (FilterChain)this);
            } else {
                try {
                    this.invoke((HttpServletRequest)request, (HttpServletResponse)response);
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
            }
        }

        private void invoke(HttpServletRequest request, HttpServletResponse response) throws Exception {
            CubbyFilter cubbyFilter = new CubbyFilter();
            cubbyFilter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)this);
        }
    }
}

