/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.cubby.controller.MessagesBehaviour;
import org.seasar.cubby.filter.CubbyHttpServletRequestWrapper;
import org.seasar.cubby.internal.controller.ActionProcessor;
import org.seasar.cubby.internal.controller.ActionResultWrapper;
import org.seasar.cubby.internal.controller.ThreadContext;
import org.seasar.cubby.internal.controller.impl.ActionProcessorImpl;
import org.seasar.cubby.internal.util.LogMessages;
import org.seasar.cubby.internal.util.RequestUtils;
import org.seasar.cubby.internal.util.StringUtils;
import org.seasar.cubby.plugin.Plugin;
import org.seasar.cubby.plugin.PluginRegistry;
import org.seasar.cubby.plugin.RequestProcessingInvocation;
import org.seasar.cubby.plugin.RoutingInvocation;
import org.seasar.cubby.routing.PathInfo;
import org.seasar.cubby.routing.PathResolver;
import org.seasar.cubby.routing.Routing;
import org.seasar.cubby.spi.ContainerProvider;
import org.seasar.cubby.spi.PathResolverProvider;
import org.seasar.cubby.spi.ProviderFactory;
import org.seasar.cubby.spi.RequestParserProvider;
import org.seasar.cubby.spi.container.Container;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CubbyFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(CubbyFilter.class);
    public static final String IGNORE_PATH_PATTERN = "ignorePathPattern";
    private final List<Pattern> ignorePathPatterns = new ArrayList<Pattern>();

    public void init(FilterConfig config) throws ServletException {
        String ignorePathPatternString = config.getInitParameter(IGNORE_PATH_PATTERN);
        if (!StringUtils.isEmpty(ignorePathPatternString)) {
            StringTokenizer tokenizer = new StringTokenizer(ignorePathPatternString, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                Pattern pattern = Pattern.compile(token);
                this.ignorePathPatterns.add(pattern);
            }
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        PathInfo pathInfo;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String path = RequestUtils.getPath(request);
        if (logger.isDebugEnabled()) {
            logger.debug(LogMessages.format("DCUB0006", path));
        }
        if ((pathInfo = this.findPathInfo(request, response, path, this.ignorePathPatterns)) != null) {
            this.setupWrapeeRequest(request);
            request.setAttribute("org.seasar.cubby.filterChain", (Object)chain);
            try {
                this.processRequest(request, response, pathInfo);
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof ServletException) {
                    throw (ServletException)e;
                }
                throw new ServletException((Throwable)e);
            }
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private void setupWrapeeRequest(HttpServletRequest request) {
        HttpServletRequest wrapeeRequest = (HttpServletRequest)request.getAttribute("org.seasar.cubby.wrapeeRequest");
        if (wrapeeRequest == null) {
            request.setAttribute("org.seasar.cubby.wrapeeRequest", (Object)request);
        }
    }

    protected PathInfo findPathInfo(HttpServletRequest request, HttpServletResponse response, String path, List<Pattern> ignorePathPatterns) {
        PathInfo pathInfo;
        Routing routing = (Routing)RequestUtils.getAttribute((ServletRequest)request, "org.seasar.cubby.routing");
        if (routing != null) {
            request.removeAttribute("org.seasar.cubby.routing");
            pathInfo = new ForwardFromActionPathInfo(routing);
        } else if (CubbyFilter.isIgnorePath(path, ignorePathPatterns)) {
            pathInfo = null;
        } else {
            PathResolver pathResolver = this.createPathResolver();
            pathInfo = this.invokeRouting(request, response, path, pathResolver);
        }
        return pathInfo;
    }

    private static boolean isIgnorePath(String path, List<Pattern> ignorePathPatterns) {
        for (Pattern pattern : ignorePathPatterns) {
            Matcher matcher = pattern.matcher(path);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    protected PathInfo invokeRouting(HttpServletRequest request, HttpServletResponse response, String path, PathResolver pathResolver) {
        RoutingInvocationImpl routingInvocation = new RoutingInvocationImpl(path, pathResolver, request, response);
        try {
            return (PathInfo)routingInvocation.proceed();
        }
        catch (Exception e) {
            logger.warn("routing failed.", (Throwable)e);
            return null;
        }
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response, PathInfo pathInfo) throws Exception {
        CubbyHttpServletRequestWrapper wrappedRequest = new CubbyHttpServletRequestWrapper(this, request, pathInfo.getURIParameters());
        RequestProcessingInvocationImpl invocation = new RequestProcessingInvocationImpl(this, (HttpServletRequest)wrappedRequest, response, pathInfo);
        invocation.proceed();
    }

    protected Map<String, Object[]> parseRequest(HttpServletRequest request) {
        RequestParserProvider requestParserProvider = ProviderFactory.get(RequestParserProvider.class);
        Map<String, Object[]> parameterMap = requestParserProvider.getParameterMap(request);
        return parameterMap;
    }

    protected PathResolver createPathResolver() {
        PathResolverProvider pathResolverProvider = ProviderFactory.get(PathResolverProvider.class);
        PathResolver pathResolver = pathResolverProvider.getPathResolver();
        return pathResolver;
    }

    protected ActionProcessor createActionProcessor() {
        ActionProcessorImpl actionProcessor = new ActionProcessorImpl();
        return actionProcessor;
    }

    protected MessagesBehaviour createMessagesBehaviour() {
        Container container = ProviderFactory.get(ContainerProvider.class).getContainer();
        MessagesBehaviour messagesBehaviour = container.lookup(MessagesBehaviour.class);
        return messagesBehaviour;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ForwardFromActionPathInfo
    implements PathInfo {
        private final Routing routing;
        private final Map<String, String[]> uriParameters = Collections.emptyMap();

        public ForwardFromActionPathInfo(Routing routing) {
            this.routing = routing;
        }

        @Override
        public Map<String, String[]> getURIParameters() {
            return this.uriParameters;
        }

        @Override
        public Routing dispatch(Map<String, Object[]> parameterMap) {
            return this.routing;
        }
    }

    static class RequestProcessingInvocationImpl
    implements RequestProcessingInvocation {
        private CubbyFilter cubbyFilter;
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final PathInfo pathInfo;
        private final Iterator<Plugin> pluginsIterator;

        public RequestProcessingInvocationImpl(CubbyFilter cubbyFilter, HttpServletRequest request, HttpServletResponse response, PathInfo pathInfo) {
            this.cubbyFilter = cubbyFilter;
            this.request = request;
            this.response = response;
            this.pathInfo = pathInfo;
            PluginRegistry pluginRegistry = PluginRegistry.getInstance();
            this.pluginsIterator = pluginRegistry.getPlugins().iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void proceed() throws Exception {
            if (this.pluginsIterator.hasNext()) {
                Plugin plugin = this.pluginsIterator.next();
                plugin.invokeRequestProcessing(this);
            } else {
                HttpServletRequest request = this.getRequest();
                Map<String, Object[]> parameterMap = this.cubbyFilter.parseRequest(request);
                request.setAttribute("org.seasar.cubby.params", parameterMap);
                Routing routing = this.pathInfo.dispatch(parameterMap);
                ThreadContext.enter(request, this.response);
                try {
                    ActionProcessor actionProcessor = this.cubbyFilter.createActionProcessor();
                    ActionResultWrapper actionResultWrapper = actionProcessor.process(request, this.response, routing);
                    actionResultWrapper.execute(request, this.response);
                }
                finally {
                    ThreadContext.exit();
                }
            }
            return null;
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        public HttpServletResponse getResponse() {
            return this.response;
        }

        public PathInfo getPathInfo() {
            return this.pathInfo;
        }
    }

    static class RoutingInvocationImpl
    implements RoutingInvocation {
        private final String path;
        private final PathResolver pathResolver;
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final Iterator<Plugin> pluginsIterator;

        public RoutingInvocationImpl(String path, PathResolver pathResolver, HttpServletRequest request, HttpServletResponse response) {
            this.path = path;
            this.pathResolver = pathResolver;
            this.request = request;
            this.response = response;
            PluginRegistry pluginRegistry = PluginRegistry.getInstance();
            this.pluginsIterator = pluginRegistry.getPlugins().iterator();
        }

        public PathInfo proceed() throws Exception {
            if (this.pluginsIterator.hasNext()) {
                Plugin plugin = this.pluginsIterator.next();
                return plugin.invokeRouting(this);
            }
            PathInfo pathInfo = this.pathResolver.getPathInfo(this.path, this.request.getMethod(), this.request.getCharacterEncoding());
            return pathInfo;
        }

        public String getPath() {
            return this.path;
        }

        public PathResolver getPathResolver() {
            return this.pathResolver;
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        public HttpServletResponse getResponse() {
            return this.response;
        }
    }
}

