/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.internal.controller.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.cubby.action.ActionContext;
import org.seasar.cubby.action.FieldInfo;
import org.seasar.cubby.action.MessageInfo;
import org.seasar.cubby.action.RequestParameter;
import org.seasar.cubby.converter.ConversionException;
import org.seasar.cubby.converter.ConversionHelper;
import org.seasar.cubby.converter.Converter;
import org.seasar.cubby.converter.impl.ConversionHelperImpl;
import org.seasar.cubby.internal.controller.ConversionFailure;
import org.seasar.cubby.internal.controller.RequestParameterBinder;
import org.seasar.cubby.internal.util.StringUtils;
import org.seasar.cubby.spi.ConverterProvider;
import org.seasar.cubby.spi.ProviderFactory;
import org.seasar.cubby.spi.beans.Attribute;
import org.seasar.cubby.spi.beans.BeanDesc;
import org.seasar.cubby.spi.beans.BeanDescFactory;
import org.seasar.cubby.spi.beans.ParameterizedClassDesc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestParameterBinderImpl
implements RequestParameterBinder {
    private final ConversionHelper conversionHelper = new ConversionHelperImpl();

    @Override
    public List<ConversionFailure> bind(Map<String, Object[]> parameterMap, Object dest, ActionContext actionContext) {
        Collection<Object> attributes;
        ArrayList<ConversionFailure> conversionFailures = new ArrayList<ConversionFailure>();
        if (parameterMap == null || parameterMap.isEmpty()) {
            return conversionFailures;
        }
        ConverterProvider converterProvider = ProviderFactory.get(ConverterProvider.class);
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(dest.getClass());
        if (actionContext.isBindRequestParameterToAllProperties()) {
            attributes = new ArrayList();
            attributes.addAll(beanDesc.findtPropertyAttributes());
            attributes.addAll(beanDesc.findAttributesAnnotatedWith(RequestParameter.class));
        } else {
            attributes = beanDesc.findAttributesAnnotatedWith(RequestParameter.class);
        }
        for (Attribute attribute : attributes) {
            RequestParameter requestParameter = attribute.getAnnotation(RequestParameter.class);
            String parameterName = requestParameter != null && !StringUtils.isEmpty(requestParameter.name()) ? requestParameter.name() : attribute.getName();
            if (!parameterMap.containsKey(parameterName)) continue;
            Object[] parameterValue = parameterMap.get(parameterName);
            Class<? extends Converter> converterType = requestParameter != null ? requestParameter.converter() : null;
            Object value = this.convert(converterProvider, parameterValue, attribute.getType(), attribute.getParameterizedClassDesc(), converterType, parameterName, conversionFailures);
            attribute.setValue(dest, value);
        }
        return conversionFailures;
    }

    private Object convert(ConverterProvider converterProvider, Object[] values, Class<?> destClass, ParameterizedClassDesc parameterizedClassDesc, Class<? extends Converter> converterType, String parameterName, List<ConversionFailure> conversionFailures) {
        Converter converter;
        if (converterType != null && !converterType.equals(Converter.class)) {
            converter = converterProvider.getConverter(converterType);
        } else {
            Class<?> componentType = values.getClass().getComponentType();
            converter = converterProvider.getConverter(componentType, destClass);
        }
        if (converter != null) {
            try {
                return converter.convertToObject(values[0], destClass, this.conversionHelper);
            }
            catch (ConversionException e) {
                FieldInfo fieldInfo = new FieldInfo(parameterName);
                MessageInfo messageInfo = e.getMessageInfo();
                ConversionFailure conversionFaiure = new ConversionFailure(parameterName, messageInfo, fieldInfo);
                conversionFailures.add(conversionFaiure);
                return null;
            }
        }
        if (destClass.isArray()) {
            return this.convertToArray(converterProvider, values, destClass.getComponentType(), parameterName, conversionFailures);
        }
        if (List.class.isAssignableFrom(destClass)) {
            ArrayList<Object> list = new ArrayList<Object>();
            this.convertToCollection(converterProvider, values, list, destClass, parameterizedClassDesc, parameterName, conversionFailures);
            return list;
        }
        if (Set.class.isAssignableFrom(destClass)) {
            LinkedHashSet<Object> set = new LinkedHashSet<Object>();
            this.convertToCollection(converterProvider, values, set, destClass, parameterizedClassDesc, parameterName, conversionFailures);
            return set;
        }
        try {
            return this.convertToScalar(converterProvider, values[0], destClass);
        }
        catch (ConversionException e) {
            FieldInfo fieldInfo = new FieldInfo(parameterName);
            MessageInfo messageInfo = e.getMessageInfo();
            ConversionFailure conversionFaiure = new ConversionFailure(parameterName, messageInfo, fieldInfo);
            conversionFailures.add(conversionFaiure);
            return null;
        }
    }

    private Object convertToArray(ConverterProvider converterProvider, Object[] values, Class<?> componentType, String parameterName, List<ConversionFailure> conversionFailures) {
        Object dest = Array.newInstance(componentType, values.length);
        for (int i = 0; i < values.length; ++i) {
            try {
                Object convertedValue = this.convertToScalar(converterProvider, values[i], componentType);
                Array.set(dest, i, convertedValue);
                continue;
            }
            catch (ConversionException e) {
                FieldInfo fieldInfo = new FieldInfo(parameterName, i);
                MessageInfo messageInfo = e.getMessageInfo();
                ConversionFailure conversionFaiure = new ConversionFailure(parameterName, messageInfo, fieldInfo);
                conversionFailures.add(conversionFaiure);
            }
        }
        return dest;
    }

    private void convertToCollection(ConverterProvider converterProvider, Object[] values, Collection<Object> collection, Class<?> type, ParameterizedClassDesc parameterizedClassDesc, String parameterName, List<ConversionFailure> conversionFailures) {
        if (parameterizedClassDesc != null && parameterizedClassDesc.isParameterizedClass()) {
            Class<?> destElementType = parameterizedClassDesc.getArguments()[0].getRawClass();
            for (int i = 0; i < values.length; ++i) {
                Object value = values[i];
                try {
                    Object convertedValue = this.convertToScalar(converterProvider, value, destElementType);
                    collection.add(convertedValue);
                    continue;
                }
                catch (ConversionException e) {
                    collection.add(null);
                    FieldInfo fieldInfo = new FieldInfo(parameterName, i);
                    MessageInfo messageInfo = e.getMessageInfo();
                    ConversionFailure conversionFaiure = new ConversionFailure(parameterName, messageInfo, fieldInfo);
                    conversionFailures.add(conversionFaiure);
                }
            }
        } else {
            for (Object value : values) {
                collection.add(value);
            }
        }
    }

    private Object convertToScalar(ConverterProvider converterProvider, Object value, Class<?> destClass) throws ConversionException {
        if (value == null) {
            return null;
        }
        if (destClass.isAssignableFrom(value.getClass())) {
            return value;
        }
        Converter converter = converterProvider.getConverter(value.getClass(), destClass);
        if (converter == null) {
            return null;
        }
        return converter.convertToObject(value, destClass, this.conversionHelper);
    }
}

