/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.internal.plugin;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import org.seasar.cubby.internal.util.LogMessages;
import org.seasar.cubby.internal.util.ServiceLoader;
import org.seasar.cubby.plugin.Plugin;
import org.seasar.cubby.plugin.PluginRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginManager {
    private static final Logger logger = LoggerFactory.getLogger(PluginManager.class);
    private final PluginRegistry pluginRegistry;

    public PluginManager(PluginRegistry pluginRegistry) {
        this.pluginRegistry = pluginRegistry;
    }

    public void init(ServletContext servletContext) throws Exception {
        Collection<Plugin> plugins = this.loadPlugins();
        this.initializePlugins(servletContext, plugins);
        this.registerPlugins(this.pluginRegistry, plugins);
        this.readyPlugins(plugins);
    }

    public void destroy() {
        Set<Plugin> plugins = this.pluginRegistry.getPlugins();
        this.destroyPlugins(plugins);
        this.pluginRegistry.clear();
    }

    protected Collection<Plugin> loadPlugins() {
        LinkedHashSet<Plugin> plugins = new LinkedHashSet<Plugin>();
        for (Plugin plugin : ServiceLoader.load(Plugin.class)) {
            plugins.add(plugin);
        }
        return plugins;
    }

    protected void initializePlugins(ServletContext servletContext, Collection<Plugin> plugins) throws Exception {
        for (Plugin plugin : plugins) {
            if (logger.isDebugEnabled()) {
                logger.debug(LogMessages.format("DCUB0019", plugin));
            }
            plugin.initialize(servletContext);
            if (!logger.isInfoEnabled()) continue;
            logger.info(LogMessages.format("ICUB0002", plugin));
        }
    }

    protected void registerPlugins(PluginRegistry pluginRegistry, Collection<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            if (logger.isDebugEnabled()) {
                logger.debug(LogMessages.format("DCUB0020", plugin));
            }
            pluginRegistry.register(plugin);
            if (!logger.isInfoEnabled()) continue;
            logger.info(LogMessages.format("ICUB0003", plugin));
        }
    }

    private void readyPlugins(Collection<Plugin> plugins) throws Exception {
        for (Plugin plugin : plugins) {
            if (logger.isDebugEnabled()) {
                logger.debug(LogMessages.format("DCUB0021", plugin));
            }
            plugin.ready();
            if (!logger.isInfoEnabled()) continue;
            logger.info(LogMessages.format("ICUB0004", plugin));
        }
    }

    protected void destroyPlugins(Set<? extends Plugin> plugins) {
        for (Plugin plugin : plugins) {
            if (logger.isDebugEnabled()) {
                logger.debug(LogMessages.format("DCUB0022", plugin));
            }
            plugin.destroy();
            if (!logger.isInfoEnabled()) continue;
            logger.info(LogMessages.format("ICUB0005", plugin));
        }
    }
}

