/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.plugins.spring.spi;

import org.seasar.cubby.spi.ContainerProvider;
import org.seasar.cubby.spi.container.Container;
import org.seasar.cubby.spi.container.LookupException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringContainerProvider
implements ContainerProvider,
ApplicationContextAware {
    private Container container;

    public Container getContainer() {
        return this.container;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.container = new SpringContainerImpl(applicationContext);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SpringContainerImpl
    implements Container {
        private final ApplicationContext applicationContext;

        public SpringContainerImpl(ApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        public <T> T lookup(Class<T> type) throws LookupException {
            String[] names = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, type);
            if (names == null || names.length < 1) {
                throw new LookupException(type + " component not found.");
            }
            return type.cast(this.applicationContext.getBean(names[0], type));
        }
    }
}

