/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.internal.controller.impl;

import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.cubby.action.ActionContext;
import org.seasar.cubby.action.ActionResult;
import org.seasar.cubby.internal.controller.ActionResultWrapper;
import org.seasar.cubby.plugin.ActionResultInvocation;
import org.seasar.cubby.plugin.Plugin;
import org.seasar.cubby.plugin.PluginRegistry;

class ActionResultWrapperImpl
implements ActionResultWrapper {
    private final ActionResult actionResult;
    private final ActionContext actionContext;

    public ActionResultWrapperImpl(ActionResult actionResult, ActionContext actionContext) {
        this.actionResult = actionResult;
        this.actionContext = actionContext;
    }

    public void execute(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionResultInvocationImpl actionResultInvocation = new ActionResultInvocationImpl(request, response, this.actionContext, this.actionResult);
        actionResultInvocation.proceed();
    }

    public ActionResult getActionResult() {
        return this.actionResult;
    }

    static class ActionResultInvocationImpl
    implements ActionResultInvocation {
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final ActionContext actionContext;
        private final ActionResult actionResult;
        private final Iterator<Plugin> pluginsIterator;

        public ActionResultInvocationImpl(HttpServletRequest request, HttpServletResponse response, ActionContext actionContext, ActionResult actionResult) {
            this.request = request;
            this.response = response;
            this.actionContext = actionContext;
            this.actionResult = actionResult;
            PluginRegistry pluginRegistry = PluginRegistry.getInstance();
            this.pluginsIterator = pluginRegistry.getPlugins().iterator();
        }

        public Void proceed() throws Exception {
            if (this.pluginsIterator.hasNext()) {
                Plugin plugin = this.pluginsIterator.next();
                plugin.invokeActionResult(this);
            } else {
                ActionResult actionResult = this.getActionResult();
                actionResult.execute(this.actionContext, this.request, this.response);
            }
            return null;
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        public HttpServletResponse getResponse() {
            return this.response;
        }

        public ActionContext getActionContext() {
            return this.actionContext;
        }

        public ActionResult getActionResult() {
            return this.actionResult;
        }
    }
}

