/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;

public abstract class GenericTypeResolver {
    private static final Map typeVariableCache = Collections.synchronizedMap(new WeakHashMap());

    public static Type getTargetType(MethodParameter methodParam) {
        Assert.notNull(methodParam, "MethodParameter must not be null");
        if (methodParam.getConstructor() != null) {
            return methodParam.getConstructor().getGenericParameterTypes()[methodParam.getParameterIndex()];
        }
        if (methodParam.getParameterIndex() >= 0) {
            return methodParam.getMethod().getGenericParameterTypes()[methodParam.getParameterIndex()];
        }
        return methodParam.getMethod().getGenericReturnType();
    }

    public static Class resolveParameterType(MethodParameter methodParam, Class clazz) {
        Type genericType = GenericTypeResolver.getTargetType(methodParam);
        Assert.notNull(clazz, "Class must not be null");
        Map typeVariableMap = GenericTypeResolver.getTypeVariableMap(clazz);
        Type rawType = GenericTypeResolver.getRawType(genericType, typeVariableMap);
        Class result = rawType instanceof Class ? (Class)rawType : methodParam.getParameterType();
        methodParam.setParameterType(result);
        methodParam.typeVariableMap = typeVariableMap;
        return result;
    }

    public static Class resolveReturnType(Method method, Class clazz) {
        Assert.notNull(method, "Method must not be null");
        Type genericType = method.getGenericReturnType();
        Assert.notNull(clazz, "Class must not be null");
        Map typeVariableMap = GenericTypeResolver.getTypeVariableMap(clazz);
        Type rawType = GenericTypeResolver.getRawType(genericType, typeVariableMap);
        return rawType instanceof Class ? (Class<?>)rawType : method.getReturnType();
    }

    static Class resolveType(Type genericType, Map typeVariableMap) {
        Type rawType = GenericTypeResolver.getRawType(genericType, typeVariableMap);
        return rawType instanceof Class ? (Class)rawType : Object.class;
    }

    static Type getRawType(Type genericType, Map typeVariableMap) {
        TypeVariable tv;
        Type resolvedType = genericType;
        if (genericType instanceof TypeVariable && (resolvedType = (Type)typeVariableMap.get(tv = (TypeVariable)genericType)) == null) {
            resolvedType = GenericTypeResolver.extractBoundForTypeVariable(tv);
        }
        if (resolvedType instanceof ParameterizedType) {
            return ((ParameterizedType)resolvedType).getRawType();
        }
        return resolvedType;
    }

    static Map getTypeVariableMap(Class clazz) {
        Reference ref = (Reference)typeVariableCache.get(clazz);
        HashMap typeVariableMap = ref != null ? ref.get() : null;
        if (typeVariableMap == null) {
            ParameterizedType pt;
            Class<?> type;
            typeVariableMap = new HashMap();
            GenericTypeResolver.extractTypeVariablesFromGenericInterfaces(clazz.getGenericInterfaces(), typeVariableMap);
            Type genericType = clazz.getGenericSuperclass();
            for (type = clazz.getSuperclass(); type != null && !(class$java$lang$Object == null ? GenericTypeResolver.class$("java.lang.Object") : class$java$lang$Object).equals(type); type = type.getSuperclass()) {
                if (genericType instanceof ParameterizedType) {
                    pt = (ParameterizedType)genericType;
                    GenericTypeResolver.populateTypeMapFromParameterizedType(pt, typeVariableMap);
                }
                GenericTypeResolver.extractTypeVariablesFromGenericInterfaces(type.getGenericInterfaces(), typeVariableMap);
                genericType = type.getGenericSuperclass();
            }
            type = clazz;
            while (type.isMemberClass()) {
                genericType = type.getGenericSuperclass();
                if (genericType instanceof ParameterizedType) {
                    pt = (ParameterizedType)genericType;
                    GenericTypeResolver.populateTypeMapFromParameterizedType(pt, typeVariableMap);
                }
                type = type.getEnclosingClass();
            }
            typeVariableCache.put(clazz, new WeakReference(typeVariableMap));
        }
        return typeVariableMap;
    }

    static Type extractBoundForTypeVariable(TypeVariable typeVariable) {
        Type[] bounds = typeVariable.getBounds();
        if (bounds.length == 0) {
            return Object.class;
        }
        Type bound = bounds[0];
        if (bound instanceof TypeVariable) {
            bound = GenericTypeResolver.extractBoundForTypeVariable((TypeVariable)bound);
        }
        return bound;
    }

    private static void extractTypeVariablesFromGenericInterfaces(Type[] genericInterfaces, Map typeVariableMap) {
        for (int i = 0; i < genericInterfaces.length; ++i) {
            Type genericInterface = genericInterfaces[i];
            if (genericInterface instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericInterface;
                GenericTypeResolver.populateTypeMapFromParameterizedType(pt, typeVariableMap);
                if (!(pt.getRawType() instanceof Class)) continue;
                GenericTypeResolver.extractTypeVariablesFromGenericInterfaces(((Class)pt.getRawType()).getGenericInterfaces(), typeVariableMap);
                continue;
            }
            if (!(genericInterface instanceof Class)) continue;
            GenericTypeResolver.extractTypeVariablesFromGenericInterfaces(((Class)genericInterface).getGenericInterfaces(), typeVariableMap);
        }
    }

    private static void populateTypeMapFromParameterizedType(ParameterizedType type, Map typeVariableMap) {
        if (type.getRawType() instanceof Class) {
            Type[] actualTypeArguments = type.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeVariables = ((Class)type.getRawType()).getTypeParameters();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                Type actualTypeArgument = actualTypeArguments[i];
                TypeVariable variable = typeVariables[i];
                if (actualTypeArgument instanceof Class) {
                    typeVariableMap.put(variable, actualTypeArgument);
                    continue;
                }
                if (actualTypeArgument instanceof GenericArrayType) {
                    typeVariableMap.put(variable, actualTypeArgument);
                    continue;
                }
                if (actualTypeArgument instanceof ParameterizedType) {
                    typeVariableMap.put(variable, actualTypeArgument);
                    continue;
                }
                if (!(actualTypeArgument instanceof TypeVariable)) continue;
                TypeVariable typeVariableArgument = (TypeVariable)actualTypeArgument;
                Type resolvedType = (Type)typeVariableMap.get(typeVariableArgument);
                if (resolvedType == null) {
                    resolvedType = GenericTypeResolver.extractBoundForTypeVariable(typeVariableArgument);
                }
                typeVariableMap.put(variable, resolvedType);
            }
        }
    }
}

