/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.converter.impl;

import org.seasar.cubby.converter.ConversionHelper;
import org.seasar.cubby.converter.impl.AbstractConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanConverter
extends AbstractConverter {
    private static final String[] TRUE_STRINGS = new String[]{"yes", "y", "true", "on", "1"};

    @Override
    public Class<?> getObjectType() {
        return Boolean.class;
    }

    @Override
    public Object convertToObject(Object value, Class<?> objectType, ConversionHelper helper) {
        if (value == null) {
            return null;
        }
        return this.toBoolean(value.toString());
    }

    protected Object toBoolean(String value) {
        for (String trueString : TRUE_STRINGS) {
            if (!trueString.equalsIgnoreCase(value)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public String convertToString(Object value, ConversionHelper helper) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }
}

