/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.xml;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.URLUtil;
import org.seasar.framework.xml.TagHandler;
import org.seasar.framework.xml.TagHandlerContext;
import org.seasar.framework.xml.TagHandlerRule;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxHandler
extends DefaultHandler {
    private TagHandlerRule tagHandlerRule;
    private TagHandlerContext context = new TagHandlerContext();
    private Map dtdPaths = new HashMap();
    private Locator locator;

    public SaxHandler(TagHandlerRule tagHandlerRule) {
        this.tagHandlerRule = tagHandlerRule;
    }

    public TagHandlerContext getTagHandlerContext() {
        return this.context;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        this.context.setLocator(this.locator);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) {
        this.appendBody();
        this.context.startElement(qName);
        this.start(attributes);
    }

    public void characters(char[] buffer, int start, int length) {
        int begin = start;
        int end = start + length;
        for (int i = begin; i < end; ++i) {
            if (buffer[i] != '\n') continue;
            this.context.characters(buffer, begin, i - begin + 1);
            this.appendBody();
            begin = i + 1;
        }
        if (begin < end) {
            this.context.characters(buffer, begin, end - begin);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        this.appendBody();
        this.end();
        this.context.endElement();
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        String dtdPath;
        if (publicId != null && (dtdPath = (String)this.dtdPaths.get(publicId)) != null) {
            return this.createInputSource(ResourceUtil.getResourceAsStream(dtdPath), systemId);
        }
        if (systemId == null) {
            return null;
        }
        if (systemId.startsWith("file:")) {
            URL url = URLUtil.create(systemId);
            String path = url.getFile();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            return this.createInputSource(ResourceUtil.getResourceAsStream(path), systemId);
        }
        return new InputSource(ResourceUtil.getResourceAsStream(systemId));
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    public void warning(SAXParseException e) throws SAXException {
        System.err.println(e);
    }

    public void registerDtdPath(String publicId, String dtdPath) {
        this.dtdPaths.put(publicId, dtdPath);
    }

    public Object getResult() {
        return this.context.getResult();
    }

    private InputSource createInputSource(InputStream stream, String systemId) {
        InputSource is = new InputSource(stream);
        is.setSystemId(systemId);
        return is;
    }

    private TagHandler getTagHandlerByPath() {
        return this.tagHandlerRule.getTagHandler(this.context.getPath());
    }

    private TagHandler getTagHandlerByQName() {
        return this.tagHandlerRule.getTagHandler(this.context.getQName());
    }

    private void start(Attributes attributes) {
        TagHandler th = this.getTagHandlerByPath();
        this.start(th, attributes);
        th = this.getTagHandlerByQName();
        this.start(th, attributes);
    }

    private void start(TagHandler handler, Attributes attributes) {
        if (handler != null) {
            try {
                handler.start(this.context, attributes);
            }
            catch (RuntimeException ex) {
                this.reportDetailPath();
                ex.printStackTrace();
                throw ex;
            }
        }
    }

    private void appendBody() {
        String characters = this.context.getCharacters();
        if (characters.length() > 0) {
            TagHandler th = this.getTagHandlerByPath();
            this.appendBody(th, characters);
            th = this.getTagHandlerByQName();
            this.appendBody(th, characters);
            this.context.clearCharacters();
        }
    }

    private void appendBody(TagHandler handler, String characters) {
        if (handler != null) {
            try {
                handler.appendBody(this.context, characters);
            }
            catch (RuntimeException ex) {
                this.reportDetailPath();
                ex.printStackTrace();
                throw ex;
            }
        }
    }

    private void end() {
        String body = this.context.getBody();
        TagHandler th = this.getTagHandlerByPath();
        this.end(th, body);
        th = this.getTagHandlerByQName();
        this.end(th, body);
    }

    private void end(TagHandler handler, String body) {
        if (handler != null) {
            try {
                handler.end(this.context, body);
            }
            catch (RuntimeException ex) {
                this.reportDetailPath();
                ex.printStackTrace();
                throw ex;
            }
        }
    }

    private void reportDetailPath() {
        System.err.println("Exception occured at " + this.context.getDetailPath());
    }
}

