/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.admin.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.cubby.admin.servlet.LoopingIterator;
import org.seasar.cubby.admin.servlet.Messages;
import org.seasar.cubby.admin.servlet.Section;
import org.seasar.cubby.admin.servlet.StringUtils;
import org.seasar.cubby.routing.PathResolver;
import org.seasar.cubby.routing.Routing;
import org.seasar.cubby.spi.PathResolverProvider;
import org.seasar.cubby.spi.ProviderFactory;

class RoutingSection
implements Section {
    private HttpServletRequest request;
    private PrintWriter out;
    private Locale locale;
    private Iterator<String> rowClasses = new LoopingIterator<String>(Arrays.asList("odd", "even"));
    private Messages messages;

    public RoutingSection(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.request = request;
        this.out = response.getWriter();
        this.locale = request.getLocale();
        this.messages = new Messages(this.locale);
    }

    public void print() {
        String path = this.request.getParameter("path");
        this.out.println("<form name=\"pathSerachForm\">");
        this.out.print("<label for=\"path\">");
        this.out.print(this.messages.getString("lbl.path"));
        this.out.print("</label>");
        this.out.print("<input type=\"text\" name=\"path\" size=\"40\" value=\"");
        this.out.print(RoutingSection.escapeHtml(path));
        this.out.println("\" />");
        this.out.print("<input type=\"submit\" value=\"");
        this.out.print(this.messages.getString("lbl.test"));
        this.out.println("\">");
        this.out.print("<input type=\"button\" value=\"");
        this.out.print(this.messages.getString("lbl.clear"));
        this.out.println("\" onclick=\"pathSerachForm.path.value='';pathSerachForm.submit();\">");
        this.out.println("</form>");
        this.out.println("<table>");
        this.out.println("<thead>");
        this.out.println(RoutingSection.th(this.messages.getString("lbl.no")));
        this.out.println(RoutingSection.th(this.messages.getString("lbl.regexp")));
        this.out.println(RoutingSection.th(this.messages.getString("lbl.requestMethod")));
        this.out.println(RoutingSection.th(this.messages.getString("lbl.actionMethod")));
        this.out.println(RoutingSection.th(this.messages.getString("lbl.pathParams")));
        this.out.println(RoutingSection.th(this.messages.getString("lbl.priority")));
        this.out.println("</thead>");
        this.out.println("<tbody>");
        PathResolverProvider pathResolverProvider = (PathResolverProvider)ProviderFactory.get(PathResolverProvider.class);
        PathResolver pathResolver = pathResolverProvider.getPathResolver();
        int no = 1;
        for (Routing routing : pathResolver.getRoutings()) {
            HashMap<String, String> pathParameters;
            boolean write;
            if (path == null || path.length() == 0) {
                write = true;
                pathParameters = null;
            } else {
                Matcher matcher = routing.getPattern().matcher(path);
                if (matcher.matches()) {
                    write = true;
                    pathParameters = new HashMap<String, String>();
                    for (int i = 0; i < matcher.groupCount(); ++i) {
                        String name = (String)routing.getUriParameterNames().get(i);
                        String value = matcher.group(i + 1);
                        pathParameters.put(name, value);
                    }
                } else {
                    write = false;
                    pathParameters = null;
                }
            }
            if (write) {
                this.out.print("<tr class=\"");
                this.out.print(this.rowClasses.next());
                this.out.println("\">");
                this.out.println(RoutingSection.td(no));
                this.out.println(RoutingSection.td(routing.getPattern().pattern()));
                this.out.println(RoutingSection.td(routing.getRequestMethod()));
                this.out.println(RoutingSection.td(routing.getActionClass().getName() + "#" + routing.getActionMethod().getName()));
                if (pathParameters == null) {
                    this.out.println(RoutingSection.td(routing.getUriParameterNames()));
                } else {
                    this.out.println(RoutingSection.td(pathParameters));
                }
                this.out.println(RoutingSection.td(routing.getPriority()));
                this.out.println("</tr>");
            }
            ++no;
        }
        this.out.println("</tbody>");
        this.out.println("</table>");
    }

    private static String th(Object body) {
        return "<th>" + String.valueOf(body) + "</th>";
    }

    private static String td(Object body) {
        return "<td>" + String.valueOf(body) + "</td>";
    }

    public static String escapeHtml(Object str) {
        if (str == null) {
            return "";
        }
        String text = str.toString();
        text = StringUtils.replace(text, "&", "&amp;");
        text = StringUtils.replace(text, "<", "&lt;");
        text = StringUtils.replace(text, ">", "&gt;");
        text = StringUtils.replace(text, "\"", "&quot;");
        text = StringUtils.replace(text, "'", "&#39;");
        return text;
    }
}

