/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.easymock.internal.MockInvocationHandler;

public class ObjectMethodsFilter
implements InvocationHandler {
    private final Method equalsMethod;
    private final Method hashCodeMethod;
    private final Method toStringMethod;
    private final MockInvocationHandler delegate;

    public ObjectMethodsFilter(MockInvocationHandler delegate) {
        try {
            this.equalsMethod = Object.class.getMethod("equals", Object.class);
            this.hashCodeMethod = Object.class.getMethod("hashCode", null);
            this.toStringMethod = Object.class.getMethod("toString", null);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("An Object method could not be found!");
        }
        this.delegate = delegate;
    }

    public final Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.equalsMethod.equals(method)) {
            return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
        }
        if (this.hashCodeMethod.equals(method)) {
            return new Integer(System.identityHashCode(proxy));
        }
        if (this.toStringMethod.equals(method)) {
            return this.mockToString(proxy);
        }
        return this.delegate.invoke(proxy, method, args);
    }

    private String mockToString(Object proxy) {
        return "EasyMock for " + this.mockType(proxy);
    }

    private String mockType(Object proxy) {
        if (Proxy.isProxyClass(proxy.getClass())) {
            return proxy.getClass().getInterfaces()[0].toString();
        }
        return proxy.getClass().getSuperclass().toString();
    }

    public MockInvocationHandler getDelegate() {
        return this.delegate;
    }
}

