/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.common;

import java.io.IOException;
import org.apache.jk.core.Msg;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;

public class MsgAjp
extends Msg {
    private static Log log = LogFactory.getLog(MsgAjp.class);
    private byte[] buf;
    private int pos;
    private int len;
    private int bufsize;

    public MsgAjp(int bsize) {
        if (bsize < 8192) {
            bsize = 8192;
        }
        this.bufsize = bsize;
        this.buf = new byte[bsize];
    }

    public MsgAjp() {
        this(8192);
    }

    public void reset() {
        this.len = 4;
        this.pos = 4;
    }

    public void end() {
        this.len = this.pos;
        int dLen = this.len - 4;
        this.buf[0] = 65;
        this.buf[1] = 66;
        this.buf[2] = (byte)(dLen >>> 8 & 0xFF);
        this.buf[3] = (byte)(dLen & 0xFF);
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int getLen() {
        return this.len;
    }

    public void appendInt(int val) {
        this.buf[this.pos++] = (byte)(val >>> 8 & 0xFF);
        this.buf[this.pos++] = (byte)(val & 0xFF);
    }

    public void appendByte(int val) {
        this.buf[this.pos++] = (byte)val;
    }

    public void appendLongInt(int val) {
        this.buf[this.pos++] = (byte)(val >>> 24 & 0xFF);
        this.buf[this.pos++] = (byte)(val >>> 16 & 0xFF);
        this.buf[this.pos++] = (byte)(val >>> 8 & 0xFF);
        this.buf[this.pos++] = (byte)(val & 0xFF);
    }

    public void appendBytes(MessageBytes mb) throws IOException {
        if (mb == null || mb.isNull()) {
            this.appendInt(0);
            this.appendByte(0);
            return;
        }
        ByteChunk bc = mb.getByteChunk();
        this.appendByteChunk(bc);
    }

    public void appendByteChunk(ByteChunk bc) throws IOException {
        if (bc == null) {
            log.error((Object)"appendByteChunk() null");
            this.appendInt(0);
            this.appendByte(0);
            return;
        }
        byte[] bytes = bc.getBytes();
        int start = bc.getStart();
        int length = bc.getLength();
        this.appendInt(length);
        this.cpBytes(bytes, start, length);
        this.appendByte(0);
    }

    public void appendBytes(byte[] b, int off, int numBytes) {
        this.appendInt(numBytes);
        this.cpBytes(b, off, numBytes);
        this.appendByte(0);
    }

    private void cpBytes(byte[] b, int off, int numBytes) {
        if (this.pos + numBytes >= this.buf.length) {
            log.error((Object)("Buffer overflow: buffer.len=" + this.buf.length + " pos=" + this.pos + " data=" + numBytes));
            this.dump("Overflow/coBytes");
            log.error((Object)"Overflow ", new Throwable());
            return;
        }
        System.arraycopy(b, off, this.buf, this.pos, numBytes);
        this.pos += numBytes;
    }

    public int getInt() {
        int b1 = this.buf[this.pos++] & 0xFF;
        int b2 = this.buf[this.pos++] & 0xFF;
        return (b1 << 8) + b2;
    }

    public int peekInt() {
        int b1 = this.buf[this.pos] & 0xFF;
        int b2 = this.buf[this.pos + 1] & 0xFF;
        return (b1 << 8) + b2;
    }

    public byte getByte() {
        byte res = this.buf[this.pos++];
        return res;
    }

    public byte peekByte() {
        byte res = this.buf[this.pos];
        return res;
    }

    public void getBytes(MessageBytes mb) {
        int length = this.getInt();
        if (length == 65535 || length == -1) {
            mb.recycle();
            return;
        }
        mb.setBytes(this.buf, this.pos, length);
        mb.getCharChunk().recycle();
        this.pos += length;
        ++this.pos;
    }

    public int getBytes(byte[] dest) {
        int length = this.getInt();
        if (length > this.buf.length) {
            log.error((Object)("getBytes() buffer overflow " + length + " " + this.buf.length));
        }
        if (length == 65535 || length == -1) {
            log.info((Object)("Null string " + length));
            return 0;
        }
        System.arraycopy(this.buf, this.pos, dest, 0, length);
        this.pos += length;
        ++this.pos;
        return length;
    }

    public int getLongInt() {
        int b1 = this.buf[this.pos++] & 0xFF;
        b1 <<= 8;
        b1 |= this.buf[this.pos++] & 0xFF;
        b1 <<= 8;
        b1 |= this.buf[this.pos++] & 0xFF;
        b1 <<= 8;
        return b1 |= this.buf[this.pos++] & 0xFF;
    }

    public int getHeaderLength() {
        return 4;
    }

    public int processHeader() {
        this.pos = 0;
        int mark = this.getInt();
        this.len = this.getInt();
        if (mark != 4660 && mark != 16706) {
            log.error((Object)("BAD packet signature " + mark));
            this.dump("In: ");
            return -1;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received " + this.len + " " + this.buf[0]));
        }
        return this.len;
    }

    public void dump(String msg) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(msg + ": " + this.buf + " " + this.pos + "/" + (this.len + 4)));
        }
        int max = this.pos;
        if (this.len + 4 > this.pos) {
            max = this.len + 4;
        }
        if (max > 1000) {
            max = 1000;
        }
        if (log.isDebugEnabled()) {
            for (int j = 0; j < max; j += 16) {
                log.debug((Object)MsgAjp.hexLine(this.buf, j, this.len));
            }
        }
    }

    public static String hexLine(byte[] buf, int start, int len) {
        int i;
        StringBuffer sb = new StringBuffer();
        for (i = start; i < start + 16; ++i) {
            if (i < len + 4) {
                sb.append(MsgAjp.hex(buf[i]) + " ");
                continue;
            }
            sb.append("   ");
        }
        sb.append(" | ");
        for (i = start; i < start + 16 && i < len + 4; ++i) {
            if (!Character.isISOControl((char)buf[i])) {
                sb.append(new Character((char)buf[i]));
                continue;
            }
            sb.append(".");
        }
        return sb.toString();
    }

    private static String hex(int x) {
        String h = Integer.toHexString(x);
        if (h.length() == 1) {
            h = "0" + h;
        }
        return h.substring(h.length() - 2);
    }
}

