/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.spi.impl;

import java.util.TreeMap;
import org.seasar.cubby.converter.Converter;
import org.seasar.cubby.internal.util.LogMessages;
import org.seasar.cubby.spi.ConverterProvider;
import org.seasar.cubby.spi.impl.ConversionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConverterProvider
implements ConverterProvider {
    @Override
    public Converter getConverter(Class<? extends Converter> converterType) {
        for (Converter converter : this.getConverters()) {
            if (!converterType.isAssignableFrom(converter.getClass())) continue;
            return converter;
        }
        throw new IllegalArgumentException(LogMessages.format("ECUB0110", converterType));
    }

    @Override
    public Converter getConverter(Class<?> parameterType, Class<?> objectType) {
        Class<?> destType = ConversionUtils.getWrapperClassIfPrimitive(objectType);
        Converter converter = this.getDistanceTable(parameterType, destType);
        return converter;
    }

    private Converter getDistanceTable(Class<?> parameterType, Class<?> objectType) {
        TreeMap<Integer, Converter> distanceTable = new TreeMap<Integer, Converter>();
        for (Converter converter : this.getConverters()) {
            if (!converter.canConvert(parameterType, objectType)) continue;
            int distance = this.getDistance(converter.getObjectType(), objectType);
            distanceTable.put(distance, converter);
        }
        if (distanceTable.isEmpty()) {
            return null;
        }
        return (Converter)distanceTable.values().iterator().next();
    }

    private int getDistance(Class<?> assigner, Class<?> assignee) {
        return this.getDistance(assigner, assignee, 0);
    }

    private int getDistance(Class<?> assigner, Class<?> assignee, int distance) {
        if (assignee.equals(assigner)) {
            return distance;
        }
        if (Enum.class.equals(assigner) && assignee.isEnum()) {
            return distance + 5;
        }
        if (this.isImplements(assigner, assignee)) {
            return distance + 5;
        }
        Class<?> superClass = assigner.getSuperclass();
        if (superClass == null) {
            return distance + 10;
        }
        return this.getDistance(superClass, assignee, distance + 10);
    }

    private boolean isImplements(Class<?> assigner, Class<?> assignee) {
        return !assigner.isInterface() && assignee.isInterface() && assignee.isAssignableFrom(assigner);
    }
}

