/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.customizer;

import java.util.ArrayList;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.Pointcut;
import org.seasar.framework.aop.S2MethodInvocation;
import org.seasar.framework.aop.impl.NestedMethodInvocation;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.customizer.AbstractCustomizer;
import org.seasar.framework.container.factory.AspectDefFactory;
import org.seasar.framework.container.impl.SimpleComponentDef;
import org.seasar.framework.util.StringUtil;

public class AspectCustomizer
extends AbstractCustomizer {
    public static final String interceptorName_BINDING = "bindingType=may";
    public static final String pointcut_BINDING = "bindingType=may";
    public static final String useLookupAdapter_BINDING = "bindingType=may";
    private final List interceptorNames = new ArrayList();
    private String pointcut;
    private boolean useLookupAdapter;

    public void setInterceptorName(String interceptorName) {
        this.interceptorNames.clear();
        this.interceptorNames.add(interceptorName);
    }

    public void addInterceptorName(String interceptorName) {
        this.interceptorNames.add(interceptorName);
    }

    public void setPointcut(String pointcut) {
        this.pointcut = pointcut;
    }

    public void setUseLookupAdapter(boolean useLookupAdapter) {
        this.useLookupAdapter = useLookupAdapter;
    }

    protected void doCustomize(ComponentDef componentDef) {
        if (this.useLookupAdapter) {
            LookupAdaptorInterceptor adaptor = new LookupAdaptorInterceptor(this.interceptorNames.toArray(new String[this.interceptorNames.size()]));
            AspectDef aspectDef = AspectDefFactory.createAspectDef((ComponentDef)new SimpleComponentDef(adaptor), this.createPointcut());
            componentDef.addAspectDef(aspectDef);
        } else {
            for (int i = 0; i < this.interceptorNames.size(); ++i) {
                AspectDef aspectDef = AspectDefFactory.createAspectDef((String)this.interceptorNames.get(i), this.createPointcut());
                componentDef.addAspectDef(aspectDef);
            }
        }
    }

    protected Pointcut createPointcut() {
        if (!StringUtil.isEmpty(this.pointcut)) {
            return AspectDefFactory.createPointcut(this.pointcut);
        }
        if (this.targetInterface != null) {
            return AspectDefFactory.createPointcut(this.targetInterface);
        }
        return null;
    }

    public static class LookupAdaptorInterceptor
    extends AbstractInterceptor {
        private static final long serialVersionUID = 1L;
        protected String[] interceptorNames;

        public LookupAdaptorInterceptor(String[] interceptorNames) {
            this.interceptorNames = interceptorNames;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            S2Container container = this.getComponentDef(invocation).getContainer().getRoot();
            MethodInterceptor[] interceptors = new MethodInterceptor[this.interceptorNames.length];
            for (int i = 0; i < interceptors.length; ++i) {
                interceptors[i] = (MethodInterceptor)container.getComponent(this.interceptorNames[i]);
            }
            NestedMethodInvocation nestInvocation = new NestedMethodInvocation((S2MethodInvocation)invocation, interceptors);
            return nestInvocation.proceed();
        }
    }
}

