/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.Mergeable;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.util.StringUtils;

public class MutablePropertyValues
implements PropertyValues,
Serializable {
    private final List propertyValueList;
    private Set processedProperties;
    private volatile boolean converted = false;

    public MutablePropertyValues() {
        this.propertyValueList = new ArrayList();
    }

    public MutablePropertyValues(PropertyValues original) {
        if (original != null) {
            PropertyValue[] pvs = original.getPropertyValues();
            this.propertyValueList = new ArrayList(pvs.length);
            for (int i = 0; i < pvs.length; ++i) {
                PropertyValue newPv = new PropertyValue(pvs[i]);
                this.propertyValueList.add(newPv);
            }
        } else {
            this.propertyValueList = new ArrayList(0);
        }
    }

    public MutablePropertyValues(Map original) {
        if (original != null) {
            this.propertyValueList = new ArrayList(original.size());
            Iterator it = original.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                PropertyValue newPv = new PropertyValue((String)entry.getKey(), entry.getValue());
                this.propertyValueList.add(newPv);
            }
        } else {
            this.propertyValueList = new ArrayList(0);
        }
    }

    public MutablePropertyValues(List propertyValueList) {
        this.propertyValueList = propertyValueList != null ? propertyValueList : new ArrayList();
    }

    public List getPropertyValueList() {
        return this.propertyValueList;
    }

    public MutablePropertyValues addPropertyValues(PropertyValues other) {
        if (other != null) {
            PropertyValue[] pvs = other.getPropertyValues();
            for (int i = 0; i < pvs.length; ++i) {
                PropertyValue newPv = new PropertyValue(pvs[i]);
                this.addPropertyValue(newPv);
            }
        }
        return this;
    }

    public MutablePropertyValues addPropertyValues(Map other) {
        if (other != null) {
            Iterator it = other.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                PropertyValue newPv = new PropertyValue((String)entry.getKey(), entry.getValue());
                this.addPropertyValue(newPv);
            }
        }
        return this;
    }

    public MutablePropertyValues addPropertyValue(PropertyValue pv) {
        for (int i = 0; i < this.propertyValueList.size(); ++i) {
            PropertyValue currentPv = (PropertyValue)this.propertyValueList.get(i);
            if (!currentPv.getName().equals(pv.getName())) continue;
            pv = this.mergeIfRequired(pv, currentPv);
            this.setPropertyValueAt(pv, i);
            return this;
        }
        this.propertyValueList.add(pv);
        return this;
    }

    public void addPropertyValue(String propertyName, Object propertyValue) {
        this.addPropertyValue(new PropertyValue(propertyName, propertyValue));
    }

    public void setPropertyValueAt(PropertyValue pv, int i) {
        this.propertyValueList.set(i, pv);
    }

    private PropertyValue mergeIfRequired(PropertyValue newPv, PropertyValue currentPv) {
        Mergeable mergeable;
        Object value = newPv.getValue();
        if (value instanceof Mergeable && (mergeable = (Mergeable)value).isMergeEnabled()) {
            Object merged = mergeable.merge(currentPv.getValue());
            return new PropertyValue(newPv.getName(), merged);
        }
        return newPv;
    }

    public void removePropertyValue(String propertyName) {
        this.removePropertyValue(this.getPropertyValue(propertyName));
    }

    public void removePropertyValue(PropertyValue pv) {
        this.propertyValueList.remove(pv);
    }

    public void clear() {
        this.propertyValueList.clear();
    }

    public PropertyValue[] getPropertyValues() {
        return this.propertyValueList.toArray(new PropertyValue[this.propertyValueList.size()]);
    }

    public PropertyValue getPropertyValue(String propertyName) {
        for (int i = 0; i < this.propertyValueList.size(); ++i) {
            PropertyValue pv = (PropertyValue)this.propertyValueList.get(i);
            if (!pv.getName().equals(propertyName)) continue;
            return pv;
        }
        return null;
    }

    public void registerProcessedProperty(String propertyName) {
        if (this.processedProperties == null) {
            this.processedProperties = new HashSet();
        }
        this.processedProperties.add(propertyName);
    }

    public boolean contains(String propertyName) {
        return this.getPropertyValue(propertyName) != null || this.processedProperties != null && this.processedProperties.contains(propertyName);
    }

    public boolean isEmpty() {
        return this.propertyValueList.isEmpty();
    }

    public int size() {
        return this.propertyValueList.size();
    }

    public PropertyValues changesSince(PropertyValues old) {
        MutablePropertyValues changes = new MutablePropertyValues();
        if (old == this) {
            return changes;
        }
        Iterator it = this.propertyValueList.iterator();
        while (it.hasNext()) {
            PropertyValue newPv = (PropertyValue)it.next();
            PropertyValue pvOld = old.getPropertyValue(newPv.getName());
            if (pvOld == null) {
                changes.addPropertyValue(newPv);
                continue;
            }
            if (pvOld.equals(newPv)) continue;
            changes.addPropertyValue(newPv);
        }
        return changes;
    }

    public void setConverted() {
        this.converted = true;
    }

    public boolean isConverted() {
        return this.converted;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MutablePropertyValues)) {
            return false;
        }
        MutablePropertyValues that = (MutablePropertyValues)other;
        return ((Object)this.propertyValueList).equals(that.propertyValueList);
    }

    public int hashCode() {
        return ((Object)this.propertyValueList).hashCode();
    }

    public String toString() {
        Object[] pvs = this.getPropertyValues();
        StringBuffer sb = new StringBuffer("PropertyValues: length=" + pvs.length + "; ");
        sb.append(StringUtils.arrayToDelimitedString((Object[])pvs, (String)"; "));
        return sb.toString();
    }
}

