/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.validator.validators;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.seasar.cubby.action.MessageInfo;
import org.seasar.cubby.internal.controller.ThreadContext;
import org.seasar.cubby.internal.util.TokenHelper;
import org.seasar.cubby.validator.ArrayFieldValidator;
import org.seasar.cubby.validator.ValidationContext;

public class TokenValidator
implements ArrayFieldValidator {
    private final String messageKey;

    public TokenValidator() {
        this("valid.token");
    }

    public TokenValidator(String messageKey) {
        this.messageKey = messageKey;
    }

    public void validate(ValidationContext context, Object[] values) {
        if (values == null) {
            return;
        }
        if (values.length == 1) {
            String token = (String)values[0];
            ThreadContext currentContext = ThreadContext.getCurrentContext();
            HttpServletRequest request = currentContext.getRequest();
            HttpSession session = request.getSession(false);
            if (session == null) {
                return;
            }
            if (TokenHelper.validateToken(session, token)) {
                return;
            }
        }
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setKey(this.messageKey);
        context.addMessageInfo(messageInfo);
    }
}

