/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.routing.impl;

import java.lang.reflect.Method;
import java.util.List;
import java.util.regex.Pattern;
import org.seasar.cubby.action.RequestMethod;
import org.seasar.cubby.internal.util.StringUtils;
import org.seasar.cubby.routing.Routing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RoutingImpl
implements Routing {
    private final Class<?> actionClass;
    private final Method actionMethod;
    private final String actionPath;
    private final List<String> uriParameterNames;
    private final Pattern pattern;
    private final RequestMethod requestMethod;
    private final String onSubmit;
    private final int priority;

    RoutingImpl(Class<?> actionClass, Method actionMethod, String actionPath, List<String> uriParameterNames, Pattern pattern, RequestMethod requestMethod, String onSubmit, int priority) {
        this.actionClass = actionClass;
        this.actionMethod = actionMethod;
        this.actionPath = actionPath;
        this.uriParameterNames = uriParameterNames;
        this.pattern = pattern;
        this.requestMethod = requestMethod;
        this.onSubmit = onSubmit;
        this.priority = priority;
    }

    @Override
    public Class<?> getActionClass() {
        return this.actionClass;
    }

    @Override
    public Method getActionMethod() {
        return this.actionMethod;
    }

    @Override
    public String getActionPath() {
        return this.actionPath;
    }

    @Override
    public List<String> getUriParameterNames() {
        return this.uriParameterNames;
    }

    @Override
    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public RequestMethod getRequestMethod() {
        return this.requestMethod;
    }

    @Override
    public String getOnSubmit() {
        return this.onSubmit;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean isAcceptable(String requestMethod) {
        return StringUtils.equalsIgnoreCase(this.requestMethod.name(), requestMethod);
    }

    public String toString() {
        return "[regex=" + this.pattern + ",actionMethod=" + this.actionMethod + ",uriParameterNames=" + this.uriParameterNames + ",requestMethod=" + (Object)((Object)this.requestMethod) + ",onSubmit=" + this.onSubmit + ",priority=" + this.priority + ",auto=" + "]";
    }
}

