/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.internal.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ThreadContext {
    private static final ThreadLocal<ThreadContext> THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<ThreadContext> PREVIOUS = new ThreadLocal();
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    private ThreadContext(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public static ThreadContext getCurrentContext() {
        ThreadContext context = THREAD_LOCAL.get();
        if (context == null) {
            throw new IllegalStateException("Could not get context from ThreadLocal. run in context scope.");
        }
        return context;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public static void enter(HttpServletRequest request, HttpServletResponse response) {
        if (request == null) {
            throw new NullPointerException("request");
        }
        if (response == null) {
            throw new NullPointerException("response");
        }
        ThreadContext previous = THREAD_LOCAL.get();
        if (previous != null) {
            PREVIOUS.set(previous);
        }
        ThreadContext context = new ThreadContext(request, response);
        THREAD_LOCAL.set(context);
    }

    public static void exit() {
        ThreadContext previous = PREVIOUS.get();
        if (previous != null) {
            THREAD_LOCAL.set(previous);
        }
    }

    public static void remove() {
        THREAD_LOCAL.remove();
    }
}

