/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.types;

import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.extension.jdbc.types.AbstractValueType;
import org.seasar.extension.jdbc.util.BindVariableUtil;
import org.seasar.framework.util.SqlDateConversionUtil;

public class SqlDateType
extends AbstractValueType {
    public SqlDateType() {
        super(91);
    }

    public Object getValue(ResultSet resultSet, int index) throws SQLException {
        return resultSet.getDate(index);
    }

    public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
        return resultSet.getDate(columnName);
    }

    public Object getValue(CallableStatement cs, int index) throws SQLException {
        return cs.getDate(index);
    }

    public Object getValue(CallableStatement cs, String parameterName) throws SQLException {
        return cs.getDate(parameterName);
    }

    public void bindValue(PreparedStatement ps, int index, Object value) throws SQLException {
        if (value == null) {
            this.setNull(ps, index);
        } else {
            ps.setDate(index, this.toSqlDate(value));
        }
    }

    public void bindValue(CallableStatement cs, String parameterName, Object value) throws SQLException {
        if (value == null) {
            this.setNull(cs, parameterName);
        } else {
            cs.setDate(parameterName, this.toSqlDate(value));
        }
    }

    protected Date toSqlDate(Object value) {
        return SqlDateConversionUtil.toDate((Object)value);
    }

    public String toText(Object value) {
        if (value == null) {
            return BindVariableUtil.nullText();
        }
        return BindVariableUtil.toText(this.toSqlDate(value));
    }
}

