/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.converter.impl;

import java.math.BigDecimal;
import org.seasar.cubby.action.MessageInfo;
import org.seasar.cubby.converter.ConversionException;
import org.seasar.cubby.converter.ConversionHelper;
import org.seasar.cubby.converter.impl.AbstractConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDecimalNumberConverter
extends AbstractConverter {
    @Override
    public Object convertToObject(Object value, Class<?> objectType, ConversionHelper helper) throws ConversionException {
        if (value == null) {
            return null;
        }
        return this.convert(value.toString());
    }

    protected Number convert(String value) throws ConversionException {
        BigDecimal decimal;
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            decimal = new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            MessageInfo messageInfo = new MessageInfo();
            messageInfo.setKey("valid.number");
            throw new ConversionException(messageInfo);
        }
        BigDecimal min = this.getMinValue();
        BigDecimal max = this.getMaxValue();
        if (min != null && min.compareTo(decimal) > 0 || max != null && max.compareTo(decimal) < 0) {
            MessageInfo messageInfo = new MessageInfo();
            messageInfo.setKey("valid.range");
            messageInfo.setArguments(min.toPlainString(), max.toPlainString());
            throw new ConversionException(messageInfo);
        }
        return this.convert(decimal);
    }

    protected abstract Number convert(BigDecimal var1);

    protected abstract BigDecimal getMinValue();

    protected abstract BigDecimal getMaxValue();

    @Override
    public String convertToString(Object value, ConversionHelper helper) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }
}

