/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.validator.validators;

import java.util.regex.Pattern;
import org.seasar.cubby.action.MessageInfo;
import org.seasar.cubby.internal.util.StringUtils;
import org.seasar.cubby.validator.ScalarFieldValidator;
import org.seasar.cubby.validator.ValidationContext;

public class NumberValidator
implements ScalarFieldValidator {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^[-+]?[0-9]+[.]?[0-9]*$");
    private final String messageKey;

    public NumberValidator() {
        this("valid.number");
    }

    public NumberValidator(String messageKey) {
        this.messageKey = messageKey;
    }

    public void validate(ValidationContext context, Object value) {
        if (value instanceof String) {
            String str = (String)value;
            if (StringUtils.isEmpty(str)) {
                return;
            }
            if (NUMBER_PATTERN.matcher(str).find()) {
                return;
            }
        } else if (value == null) {
            return;
        }
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setKey(this.messageKey);
        context.addMessageInfo(messageInfo);
    }
}

