/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.mock.portlet;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletRequestDispatcher;
import org.seasar.framework.mock.portlet.MockPortletContext;
import org.seasar.framework.mock.portlet.MockPortletRequestDispatcherImpl;
import org.seasar.framework.mock.portlet.MockPortletRequestImpl;
import org.seasar.framework.util.EnumerationAdapter;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;

public class MockPortletContextImpl
implements MockPortletContext {
    public static final int MAJOR_VERSION = 1;
    public static final int MINOR_VERSION = 0;
    public static final String SERVER_INFO = "seasar/2.0";
    private String path;
    private Map attributes = new HashMap();
    private Map initParameters = new HashMap();
    private Map mimeTypes = new HashMap();

    public MockPortletContextImpl(String path) {
        if (path == null || path.charAt(0) != '/') {
            path = "/";
        }
        this.path = path;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return new EnumerationAdapter(this.attributes.keySet().iterator());
    }

    public String getInitParameter(String name) {
        return (String)this.initParameters.get(name);
    }

    public Enumeration getInitParameterNames() {
        return new EnumerationAdapter(this.initParameters.keySet().iterator());
    }

    public int getMajorVersion() {
        return 1;
    }

    public String getMimeType(String file) {
        return (String)this.mimeTypes.get(file);
    }

    public int getMinorVersion() {
        return 0;
    }

    public PortletRequestDispatcher getNamedDispatcher(String arg0) {
        return new MockPortletRequestDispatcherImpl();
    }

    public String getPortletContextName() {
        return this.path;
    }

    public String getRealPath(String path) {
        return ResourceUtil.getResource(this.adjustPath(path)).getFile();
    }

    public PortletRequestDispatcher getRequestDispatcher(String arg0) {
        return new MockPortletRequestDispatcherImpl();
    }

    public URL getResource(String path) throws MalformedURLException {
        if (ResourceUtil.isExist(path = this.adjustPath(path))) {
            return ResourceUtil.getResource(path);
        }
        return new URL(path);
    }

    public InputStream getResourceAsStream(String path) {
        if (ResourceUtil.isExist(path = this.adjustPath(path))) {
            return ResourceUtil.getResourceAsStream(path);
        }
        if (path.startsWith("WEB-INF")) {
            path = path.substring("WEB-INF".length());
            return this.getResourceAsStream(path);
        }
        return null;
    }

    public Set getResourcePaths(String path) {
        File file;
        File src = ResourceUtil.getResourceAsFile(".");
        File root = src.getParentFile();
        if (root.getName().equalsIgnoreCase("WEB-INF")) {
            root = root.getParentFile();
        }
        if (!(file = new File(root, this.adjustPath(path))).exists()) {
            String[] array = StringUtil.split(path, "/");
            if (array.length > 1) {
                path = array[array.length - 1];
            }
            do {
                file = new File(root, path);
                root = root.getParentFile();
            } while (!file.exists() && root != null);
        }
        if (file.isDirectory()) {
            HashSet<String> paths = new HashSet<String>();
            File[] files = file.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    paths.add("file:/" + files[i].getAbsolutePath());
                }
                return paths;
            }
        }
        return null;
    }

    public String getServerInfo() {
        return SERVER_INFO;
    }

    public void log(String message, Throwable ex) {
        System.out.println(message);
        ex.printStackTrace();
    }

    public void log(String message) {
        System.out.println(message);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void setInitParameter(String name, String value) {
        this.initParameters.put(name, value);
    }

    public void addMimeType(String file, String type) {
        this.mimeTypes.put(file, type);
    }

    protected String adjustPath(String path) {
        if (path != null && path.length() >= 0 && path.charAt(0) == '/') {
            return path.substring(1);
        }
        return path;
    }

    public MockPortletRequestImpl createRequest() {
        return new MockPortletRequestImpl(this);
    }
}

