/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.where;

import org.seasar.extension.jdbc.Where;
import org.seasar.extension.jdbc.where.ComposableWhere;
import org.seasar.extension.jdbc.where.ComposableWhereContext;

public class CompositeWhere
extends ComposableWhere {
    protected String operator;

    public CompositeWhere(String operator, Where ... children) {
        super(children);
        this.operator = operator;
    }

    protected void visit(ComposableWhereContext context) {
        if (this.children.isEmpty()) {
            return;
        }
        context.append('(');
        int len = context.getCriteriaLength();
        int cutBack = 1;
        for (Where child : this.children) {
            int newLen = context.append(child).getCriteriaLength();
            if (len == newLen) continue;
            len = context.append(") ").append(this.operator).append(" (").getCriteriaLength();
            cutBack = this.operator.length() + 3;
        }
        context.cutBack(cutBack);
    }
}

