/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;

public class URLBodyEncoder {
    protected static byte ESCAPE_CHAR;
    protected static final BitSet WWW_FORM_URL;

    private URLBodyEncoder() {
    }

    public static final byte[] encodeUrl(BitSet urlsafe, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (urlsafe == null) {
            urlsafe = WWW_FORM_URL;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int n : bytes) {
            int b1 = n;
            int b2 = b1 < 0 ? b1 + 256 : b1;
            if (urlsafe.get(b2)) {
                buffer.write(b2);
                continue;
            }
            buffer.write(37);
            char hex1 = Character.toUpperCase(Character.forDigit(b2 >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b2 & 0xF, 16));
            buffer.write(hex1);
            buffer.write(hex2);
        }
        return buffer.toByteArray();
    }

    public static byte[] encode(byte[] bytes) {
        return URLBodyEncoder.encodeUrl(WWW_FORM_URL, bytes);
    }

    public static String encode(String pString, String charset) throws UnsupportedEncodingException {
        if (pString == null) {
            return null;
        }
        return new String(URLBodyEncoder.encode(pString.getBytes(charset)), "US-ASCII");
    }

    static {
        int i;
        ESCAPE_CHAR = (byte)37;
        WWW_FORM_URL = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            WWW_FORM_URL.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            WWW_FORM_URL.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            WWW_FORM_URL.set(i);
        }
        WWW_FORM_URL.set(45);
        WWW_FORM_URL.set(95);
        WWW_FORM_URL.set(46);
        WWW_FORM_URL.set(42);
    }
}

