/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.converter.impl;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.seasar.cubby.action.MessageInfo;
import org.seasar.cubby.converter.ConversionException;
import org.seasar.cubby.converter.impl.AbstractConverter;

public abstract class AbstractDateConverter
extends AbstractConverter {
    protected Date toDate(String value, String pattern) throws ConversionException {
        if (value == null || value.length() == 0) {
            return null;
        }
        ParsePosition parsePosition = new ParsePosition(0);
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        dateFormat.setLenient(false);
        Date date = ((DateFormat)dateFormat).parse(value, parsePosition);
        if (date != null && parsePosition.getIndex() == value.length()) {
            return date;
        }
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setKey("valid.dateFormat");
        throw new ConversionException(messageInfo);
    }

    protected String toString(Date date, String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        return dateFormat.format(date);
    }
}

