/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.interceptor;

import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.cubby.action.Action;
import org.seasar.cubby.interceptor.InterceptorUtils;
import org.seasar.cubby.validator.ValidationException;
import org.seasar.cubby.validator.ValidationProcessor;

public class ValidationInterceptor
implements MethodInterceptor {
    private ValidationProcessor validationProcessor;
    private HttpServletRequest request;

    public void setValidationProcessor(ValidationProcessor validationProcessor) {
        this.validationProcessor = validationProcessor;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Action action = InterceptorUtils.getAction(invocation);
        Class<? extends Action> actionClass = InterceptorUtils.getActionClass(invocation);
        Method method = InterceptorUtils.getMethod(invocation);
        try {
            this.validationProcessor.process(this.request, action, actionClass, method);
            return invocation.proceed();
        }
        catch (ValidationException e) {
            return this.validationProcessor.handleValidationException(e, this.request, action, method);
        }
    }
}

