/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.util;

import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;

public class LinkBuilder {
    private String protocol;
    private String host;
    private int port;
    private String file;

    public LinkBuilder() {
        this.clear();
    }

    public void clear() {
        this.protocol = null;
        this.host = null;
        this.port = -1;
        this.file = null;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        if (protocol == null) {
            throw new NullPointerException("No protocol");
        }
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        if (host == null) {
            throw new NullPointerException("No host");
        }
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        if (port < 0) {
            throw new IllegalArgumentException("Invalid port number :" + port);
        }
        this.port = port;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String toLink(HttpServletRequest request) throws MalformedURLException {
        URL newURL;
        URL requestURL = new URL(request.getRequestURL().toString());
        if (this.isRelativeLink(requestURL, newURL = new URL(this.getNewProtocol(requestURL.getProtocol()), this.getNewHost(requestURL.getHost()), this.getNewPort(requestURL.getPort()), this.getNewFile(requestURL.getFile())))) {
            return newURL.getFile();
        }
        return newURL.toExternalForm();
    }

    private boolean isRelativeLink(URL url1, URL url2) {
        if (!url1.getProtocol().equals(url2.getProtocol())) {
            return false;
        }
        if (!url1.getHost().equals(url2.getHost())) {
            return false;
        }
        return url1.getPort() == url2.getPort();
    }

    private String getNewProtocol(String requestProtocol) {
        if (this.protocol == null) {
            return requestProtocol;
        }
        return this.protocol;
    }

    private String getNewHost(String requestHost) {
        if (this.host == null) {
            return requestHost;
        }
        return this.host;
    }

    private int getNewPort(int requestPort) {
        if (this.port < 0) {
            return requestPort;
        }
        return this.port;
    }

    private String getNewFile(String currentFile) {
        if (this.file == null) {
            return currentFile;
        }
        return this.file;
    }

    public LinkBuilder protocol(String protocol) {
        this.setProtocol(protocol);
        return this;
    }

    public LinkBuilder host(String host) {
        this.setHost(host);
        return this;
    }

    public LinkBuilder port(int port) {
        this.setPort(port);
        return this;
    }

    public LinkBuilder file(String file) {
        this.setFile(file);
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this);
        builder.append(" [host=");
        builder.append(this.host);
        builder.append(",protocol=");
        builder.append(this.protocol);
        builder.append(",port=");
        builder.append(this.port);
        builder.append(",file=");
        builder.append(this.file);
        builder.append("]");
        return builder.toString();
    }
}

