/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.action;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.cubby.action.Action;
import org.seasar.cubby.action.ActionResult;
import org.seasar.cubby.action.RequestMethod;
import org.seasar.cubby.routing.PathResolver;
import org.seasar.cubby.routing.Routing;
import org.seasar.cubby.util.CubbyUtils;
import org.seasar.cubby.util.QueryStringBuilder;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Forward
implements ActionResult {
    private static final Logger logger = Logger.getLogger(Forward.class);
    private static final Map<String, String[]> EMPTY_PARAMETERS = Collections.emptyMap();
    private String path;
    private final Map<String, Routing> routings;
    private Class<? extends Action> actionClass;
    private String methodName;
    private Map<String, String[]> parameters;

    public Forward(String path) {
        this.path = path;
        this.routings = null;
    }

    public Forward(Class<? extends Action> actionClass, String methodName, Map<String, String[]> parameters) {
        this.actionClass = actionClass;
        this.methodName = methodName;
        this.parameters = parameters;
        Method method = ClassUtil.getMethod(actionClass, (String)methodName, (Class[])new Class[0]);
        ForwardRouting routing = new ForwardRouting(actionClass, method);
        this.routings = Collections.singletonMap(null, routing);
    }

    public Forward(Class<? extends Action> actionClass) {
        this(actionClass, "index");
    }

    public Forward(Class<? extends Action> actionClass, String methodName) {
        this(actionClass, methodName, EMPTY_PARAMETERS);
    }

    public String getPath(String characterEncoding) {
        if (this.isReverseLookupRedirect()) {
            S2Container container = SingletonS2ContainerFactory.getContainer();
            PathResolver pathResolver = (PathResolver)PathResolver.class.cast(container.getComponent(PathResolver.class));
            this.path = pathResolver.buildInternalForwardPath(this.parameters, characterEncoding);
        }
        return this.path;
    }

    private boolean isReverseLookupRedirect() {
        return this.actionClass != null && this.methodName != null && this.parameters != null;
    }

    @Override
    public void execute(Action action, Class<? extends Action> actionClass, Method method, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        action.invokePreRenderMethod(method);
        String forwardPath = this.calculateForwardPath(this.getPath(request.getCharacterEncoding()), actionClass, request.getCharacterEncoding());
        if (this.routings != null) {
            request.setAttribute("org.seasar.cubby.routings", this.routings);
        }
        if (logger.isDebugEnabled()) {
            logger.log("DCUB0001", new Object[]{forwardPath, this.routings});
        }
        RequestDispatcher dispatcher = request.getRequestDispatcher(forwardPath);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        if (logger.isDebugEnabled()) {
            logger.log("DCUB0002", new Object[]{forwardPath});
        }
        action.invokePostRenderMethod(method);
        if (action.getFlash() != null) {
            action.getFlash().clear();
        }
    }

    protected String calculateForwardPath(String path, Class<? extends Action> actionClass, String characterEncoding) {
        String absolutePath;
        if (this.getPath(characterEncoding).startsWith("/")) {
            absolutePath = path;
        } else {
            String actionDirectory = CubbyUtils.getActionDirectory(actionClass);
            if (StringUtil.isEmpty((String)actionDirectory)) {
                absolutePath = "/" + path;
            } else {
                StringBuilder builder = new StringBuilder();
                if (!actionDirectory.startsWith("/")) {
                    builder.append("/");
                }
                builder.append(actionDirectory);
                if (!actionDirectory.endsWith("/")) {
                    builder.append("/");
                }
                builder.append(path);
                absolutePath = builder.toString();
            }
        }
        return absolutePath;
    }

    public Forward param(String paramName, Object paramValue) {
        return this.param(paramName, new String[]{paramValue.toString()});
    }

    public Forward param(String paramName, Object[] paramValues) {
        return this.param(paramName, this.toStringArray(paramValues));
    }

    public Forward param(String paramName, String[] paramValues) {
        if (this.isReverseLookupRedirect()) {
            if (this.parameters == EMPTY_PARAMETERS) {
                this.parameters = new HashMap<String, String[]>();
            }
            this.parameters.put(paramName, paramValues);
        } else {
            QueryStringBuilder builder = new QueryStringBuilder(this.path);
            builder.addParam(paramName, paramValues);
            this.path = builder.toString();
        }
        return this;
    }

    private String[] toStringArray(Object[] paramValues) {
        String[] values = new String[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            values[i] = paramValues[i].toString();
        }
        return values;
    }

    @Deprecated
    public String getPath() {
        return this.getPath("UTF-8");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForwardRouting
    implements Routing {
        private Class<? extends Action> actionClass;
        private Method method;

        private ForwardRouting(Class<? extends Action> actionClass, Method method) {
            this.actionClass = actionClass;
            this.method = method;
        }

        @Override
        public Class<? extends Action> getActionClass() {
            return this.actionClass;
        }

        @Override
        public Method getMethod() {
            return this.method;
        }

        @Override
        public String getActionPath() {
            return null;
        }

        @Override
        public List<String> getUriParameterNames() {
            return null;
        }

        @Override
        public Pattern getPattern() {
            return null;
        }

        @Override
        public RequestMethod getRequestMethod() {
            return null;
        }

        @Override
        public String getOnSubmit() {
            return null;
        }

        @Override
        public int getPriority() {
            return 0;
        }

        @Override
        public boolean isAuto() {
            return false;
        }

        @Override
        public boolean isAcceptable(String requestMethod) {
            return true;
        }

        public String toString() {
            return "[" + this.method + "]";
        }
    }
}

