/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.validator.validators;

import org.seasar.cubby.validator.MessageHelper;
import org.seasar.cubby.validator.ScalarFieldValidator;
import org.seasar.cubby.validator.ValidationContext;
import org.seasar.framework.util.StringUtil;

public class RangeLengthValidator
implements ScalarFieldValidator {
    private final MessageHelper messageHelper;
    private final int min;
    private final int max;

    public RangeLengthValidator(int min, int max) {
        this(min, max, "valid.rangeLength");
    }

    public RangeLengthValidator(int min, int max, String messageKey) {
        this.min = min;
        this.max = max;
        this.messageHelper = new MessageHelper(messageKey);
    }

    public void validate(ValidationContext context, Object value) {
        if (value instanceof String) {
            String str = (String)value;
            if (StringUtil.isEmpty((String)str)) {
                return;
            }
            int length = str.length();
            if (length >= this.min && length <= this.max) {
                return;
            }
        } else if (value == null) {
            return;
        }
        context.addMessageInfo(this.messageHelper.createMessageInfo(this.min, this.max));
    }
}

