/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.validator.validators;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.seasar.cubby.controller.ThreadContext;
import org.seasar.cubby.util.TokenHelper;
import org.seasar.cubby.validator.ArrayFieldValidator;
import org.seasar.cubby.validator.MessageHelper;
import org.seasar.cubby.validator.ValidationContext;
import org.seasar.framework.message.MessageFormatter;

public class TokenValidator
implements ArrayFieldValidator {
    private final MessageHelper messageHelper;

    public TokenValidator() {
        this("valid.token");
    }

    public TokenValidator(String messageKey) {
        this.messageHelper = new MessageHelper(messageKey);
    }

    public void validate(ValidationContext context, Object[] values) {
        if (values != null && values.length != 1) {
            context.addMessageInfo(this.messageHelper.createMessageInfo(new Object[0]));
        } else {
            String token = (String)values[0];
            HttpServletRequest request = ThreadContext.getRequest();
            if (request == null) {
                throw new IllegalStateException(MessageFormatter.getMessage((String)"ECUB0401", null));
            }
            HttpSession session = request.getSession();
            if (!TokenHelper.validateToken(session, token)) {
                context.addMessageInfo(this.messageHelper.createMessageInfo(new Object[0]));
            }
        }
    }
}

