/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.routing.impl;

import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.cubby.routing.InternalForwardInfo;
import org.seasar.cubby.routing.PathResolver;
import org.seasar.cubby.routing.Router;
import org.seasar.cubby.util.CubbyUtils;
import org.seasar.framework.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouterImpl
implements Router {
    private static final Logger logger = Logger.getLogger(RouterImpl.class);
    private static final List<Pattern> EMPTY_IGNORE_PATH_PATTERNS = Collections.emptyList();
    private PathResolver pathResolver;

    public void setPathResolver(PathResolver pathResolver) {
        this.pathResolver = pathResolver;
    }

    @Override
    public InternalForwardInfo routing(HttpServletRequest request, HttpServletResponse response) {
        return this.routing(request, response, EMPTY_IGNORE_PATH_PATTERNS);
    }

    @Override
    public InternalForwardInfo routing(HttpServletRequest request, HttpServletResponse response, List<Pattern> ignorePathPatterns) {
        String path = CubbyUtils.getPath(request);
        if (logger.isDebugEnabled()) {
            logger.log("DCUB0006", new Object[]{path});
        }
        if (this.isIgnorePath(path, ignorePathPatterns)) {
            return null;
        }
        InternalForwardInfo internalForwardInfo = this.pathResolver.getInternalForwardInfo(path, request.getMethod(), request.getCharacterEncoding());
        return internalForwardInfo;
    }

    private boolean isIgnorePath(String path, List<Pattern> ignorePathPatterns) {
        for (Pattern pattern : ignorePathPatterns) {
            Matcher matcher = pattern.matcher(path);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }
}

