/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.tags;

import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.DynamicAttributes;
import org.seasar.cubby.tags.LinkSupport;
import org.seasar.cubby.tags.ParamParent;
import org.seasar.cubby.tags.TagUtils;
import org.seasar.cubby.util.LinkBuilder;

public class LinkTag
extends BodyTagSupport
implements DynamicAttributes,
ParamParent {
    private static final long serialVersionUID = 1L;
    private final Map<String, Object> attrs = new HashMap<String, Object>();
    private final LinkSupport linkSupport = new LinkSupport();
    private final LinkBuilder linkBuilder = new LinkBuilder();
    private String tag;
    private String attr;
    private boolean encodeURL = true;

    public void setDynamicAttribute(String uri, String localName, Object value) throws JspException {
        this.attrs.put(localName, value);
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setAttr(String attr) {
        this.attr = attr;
    }

    public void setActionClass(String actionClass) {
        this.linkSupport.setActionClassName(actionClass);
    }

    public void setActionMethod(String actionMethod) {
        this.linkSupport.setActionMethodName(actionMethod);
    }

    public void setEncodeURL(boolean encodeURL) {
        this.encodeURL = encodeURL;
    }

    public void setProtocol(String protocol) {
        this.linkBuilder.setProtocol(protocol);
    }

    public void setPort(int port) {
        this.linkBuilder.setPort(port);
    }

    public void addParameter(String name, String value) {
        this.linkSupport.addParameter(name, value);
    }

    public int doStartTag() throws JspException {
        return 2;
    }

    public int doEndTag() throws JspException {
        String url;
        String actionPath;
        String contextPath = (String)this.pageContext.getAttribute("contextPath", 2);
        String characterEncoding = this.pageContext.getRequest().getCharacterEncoding();
        if (this.encodeURL) {
            HttpServletResponse response = (HttpServletResponse)HttpServletResponse.class.cast(this.pageContext.getResponse());
            actionPath = response.encodeURL(contextPath + this.linkSupport.getPath(characterEncoding));
        } else {
            actionPath = contextPath + this.linkSupport.getPath(characterEncoding);
        }
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        try {
            url = this.linkBuilder.file(actionPath).toLink(request);
        }
        catch (MalformedURLException e) {
            throw new JspException((Throwable)e);
        }
        try {
            JspWriter out = this.pageContext.getOut();
            if (this.tag == null) {
                out.write(url);
                BodyContent bodyContent = this.getBodyContent();
                if (bodyContent != null) {
                    bodyContent.writeOut((Writer)out);
                }
            } else {
                this.attrs.put(this.attr, url);
                out.write("<");
                out.write(this.tag);
                out.write(" ");
                out.write(TagUtils.toAttr(this.attrs));
                out.write(">");
                BodyContent bodyContent = this.getBodyContent();
                if (bodyContent != null) {
                    bodyContent.writeOut((Writer)out);
                }
                out.write("</");
                out.write(this.tag);
                out.write(">");
            }
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        this.reset();
        return 6;
    }

    private void reset() {
        this.linkSupport.clear();
        this.linkBuilder.clear();
        this.attrs.clear();
        this.tag = null;
        this.attr = null;
        this.encodeURL = true;
    }
}

