/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.controller.impl;

import org.seasar.cubby.action.FormatPattern;
import org.seasar.cubby.action.impl.FormatPatternImpl;
import org.seasar.cubby.controller.CubbyConfiguration;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.log.Logger;

public class CubbyConfigurationImpl
implements CubbyConfiguration {
    private static final Logger logger = Logger.getLogger(CubbyConfiguration.class);
    private final FormatPattern formatPattern;

    public FormatPattern getFormatPattern() {
        return this.formatPattern;
    }

    public CubbyConfigurationImpl(S2Container container) {
        S2Container root = container.getRoot();
        if (root.hasComponentDef(FormatPattern.class)) {
            ComponentDef componentDef = root.getComponentDef(FormatPattern.class);
            this.formatPattern = (FormatPattern)componentDef.getComponent();
            if (logger.isDebugEnabled()) {
                logger.log("DCUB0009", new Object[]{FormatPattern.class, this.formatPattern});
            }
        } else {
            this.formatPattern = new FormatPatternImpl();
            if (logger.isDebugEnabled()) {
                logger.log("DCUB0008", new Object[]{FormatPattern.class, this.formatPattern});
            }
        }
    }
}

