/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.dialect.mysql;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jiemamy.JiemamyContext;
import org.jiemamy.dialect.DefaultSqlEmitter;
import org.jiemamy.dialect.Dialect;
import org.jiemamy.dialect.TokenResolver;
import org.jiemamy.dialect.mysql.MySqlTokenResolver;
import org.jiemamy.dialect.mysql.internal.MySqlIdentifier;
import org.jiemamy.dialect.mysql.parameter.MySqlParameterKeys;
import org.jiemamy.dialect.mysql.parameter.StorageEngineType;
import org.jiemamy.model.DbObject;
import org.jiemamy.model.sql.Identifier;
import org.jiemamy.model.sql.Keyword;
import org.jiemamy.model.sql.Separator;
import org.jiemamy.model.sql.SimpleSqlStatement;
import org.jiemamy.model.sql.SqlStatement;
import org.jiemamy.model.sql.Token;
import org.jiemamy.model.table.JmTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySqlEmitter
extends DefaultSqlEmitter {
    public MySqlEmitter(Dialect dialect) {
        this(dialect, (TokenResolver)new MySqlTokenResolver());
    }

    protected MySqlEmitter(Dialect dialect, TokenResolver tokenResolver) {
        super(dialect, tokenResolver);
    }

    protected SqlStatement emitCreateDbObjectStatement(JiemamyContext context, DbObject dbObject) {
        JmTable table;
        StorageEngineType engineType;
        SimpleSqlStatement statement = (SimpleSqlStatement)super.emitCreateDbObjectStatement(context, dbObject);
        List<Token> tokens = statement.toTokens();
        tokens = this.convertIdentifierToMySqlIdentifier(tokens);
        if (dbObject instanceof JmTable && (engineType = (StorageEngineType)(table = (JmTable)dbObject).getParam(MySqlParameterKeys.STORAGE_ENGINE)) != null && !StringUtils.isEmpty((String)((Object)engineType).toString())) {
            String engineName = ((Object)engineType).toString();
            tokens.addAll(tokens.size() - 1, Arrays.asList(Keyword.of((String)"ENGINE"), Separator.EQUAL, Keyword.of((String)engineName)));
        }
        return new SimpleSqlStatement(tokens);
    }

    protected SqlStatement emitDropDbObjectStatement(DbObject dbObject) {
        SimpleSqlStatement stmt = (SimpleSqlStatement)super.emitDropDbObjectStatement(dbObject);
        List<Token> tokens = stmt.toTokens();
        tokens = this.convertIdentifierToMySqlIdentifier(tokens);
        tokens.addAll(2, Arrays.asList(Keyword.of((String)"IF"), Keyword.of((String)"EXISTS")));
        return new SimpleSqlStatement(tokens);
    }

    private List<Token> convertIdentifierToMySqlIdentifier(List<Token> tokens) {
        ArrayList result = Lists.newArrayListWithCapacity((int)tokens.size());
        for (Token token : tokens) {
            if (token instanceof Identifier) {
                Identifier identifier = (Identifier)token;
                result.add(MySqlIdentifier.of(identifier.toString()));
                continue;
            }
            result.add(token);
        }
        return result;
    }
}

