/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.Validate;
import org.slf4j.Marker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LogMarker implements Marker,
Iterable<Marker>
{
    MARKER_ROOT("org.jiemamy"),
    DESIGN("org.jiemamy.design"),
    BOUNDARY("org.jiemamy.boundary"),
    LIFECYCLE("org.jiemamy.lifecycle"),
    DETAIL("org.jiemamy.detail");

    private static final String OPEN = "[ ";
    private static final String CLOSE = " ]";
    private static final String SEP = ", ";
    private final String name;
    private List<Marker> refereceList;

    private LogMarker(String name) {
        this.name = name;
    }

    public void add(Marker reference) {
        Validate.notNull((Object)reference, (String)"A null value cannot be added to a Marker as reference.");
        if (this.contains(reference)) {
            return;
        }
        if (reference.contains((Marker)this)) {
            return;
        }
        if (this.refereceList == null) {
            this.refereceList = new Vector<Marker>();
        }
        this.refereceList.add(reference);
    }

    public boolean contains(Marker other) {
        Validate.notNull((Object)other);
        if (this.equals(other)) {
            return true;
        }
        if (this.hasReferences()) {
            for (int i = 0; i < this.refereceList.size(); ++i) {
                Marker ref = this.refereceList.get(i);
                if (!ref.contains(other)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(String name) {
        Validate.notNull((Object)name);
        if (this.name.equals(name)) {
            return true;
        }
        if (this.hasReferences()) {
            for (int i = 0; i < this.refereceList.size(); ++i) {
                Marker ref = this.refereceList.get(i);
                if (!ref.contains(name)) continue;
                return true;
            }
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public boolean hasChildren() {
        return this.hasReferences();
    }

    public boolean hasReferences() {
        return this.refereceList != null && this.refereceList.size() > 0;
    }

    @Override
    public Iterator<Marker> iterator() {
        if (this.refereceList != null) {
            return this.refereceList.iterator();
        }
        return Iterators.emptyIterator();
    }

    public boolean remove(Marker referenceToRemove) {
        if (this.refereceList == null) {
            return false;
        }
        for (Marker m : this) {
            if (!referenceToRemove.equals(m)) continue;
            this.refereceList.remove(m);
            return true;
        }
        return false;
    }

    public String toString() {
        if (!this.hasReferences()) {
            return this.getName();
        }
        Iterator<Marker> it = this.iterator();
        StringBuffer sb = new StringBuffer(this.getName());
        sb.append(' ').append(OPEN);
        while (it.hasNext()) {
            Marker reference = it.next();
            sb.append(reference.getName());
            if (!it.hasNext()) continue;
            sb.append(SEP);
        }
        sb.append(CLOSE);
        return sb.toString();
    }

    static {
        for (LogMarker m : LogMarker.values()) {
            if (m == MARKER_ROOT) continue;
            MARKER_ROOT.add(m);
        }
    }
}

