/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.lib.impl;

import java.util.List;

import junit.framework.TestCase;

import org.seasar.codegen.lib.BindValue;
import org.seasar.codegen.lib.Column;
import org.seasar.codegen.lib.Operator;
import org.seasar.codegen.lib.Order;
import org.seasar.codegen.lib.Query;

/**
 * @author azusa
 * 
 */
public class ConditionResultImplTest extends TestCase {

    private ConditionResultImpl conditionResultImpl = new ConditionResultImpl();

    private Column column1 = new ColumnImpl("aaa", "bbb", null);

    private Column column2 = new ColumnImpl("ccc", "ddd", null);

    /*
     * (非 Javadoc)
     * 
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * {@link org.seasar.codegen.lib.impl.ConditionResultImpl#addOrder(org.seasar.codegen.lib.Column, boolean)}
     * のためのテスト・メソッド。
     */
    public void testAddOrder() {
        createOrder();
        assertEquals(2, conditionResultImpl.getOrderList().size());
    }

    /**
     * {@link org.seasar.codegen.lib.impl.ConditionResultImpl#addQuery(java.lang.String, java.lang.Object[])}
     * のためのテスト・メソッド。
     */
    public void testAddQuery() {
        conditionResultImpl.addQuery("abc=?", 1);
        Query query = conditionResultImpl.getQuery();
        assertEquals("abc=?", query.getQuery());
        assertEquals(1, query.getArgs()[0]);
    }

    /**
     * {@link org.seasar.codegen.lib.impl.ConditionResultImpl#getBindValues()}
     * のためのテスト・メソッド。
     */
    public void testGetBindValues() {
        conditionResultImpl.addBindValue(new BindValueImpl(column1, Operator.EQUAL, new Object[] { 1 }));
        conditionResultImpl.addBindValue(new BindValueImpl(column2, Operator.EQUAL, new Object[] { 1 }));
        List<BindValue> list = conditionResultImpl.getBindValues();
        assertEquals(2, list.size());
        assertEquals(column1, list.get(0).getColumn());
        assertEquals(Operator.EQUAL, list.get(0).getOperator());
        assertEquals(1, list.get(0).getArgs()[0]);

        assertEquals(column2, list.get(1).getColumn());
        assertEquals(Operator.EQUAL, list.get(1).getOperator());
        assertEquals(1, list.get(1).getArgs()[0]);

    }

    /**
     * {@link org.seasar.codegen.lib.impl.ConditionResultImpl#getOrderList()}
     * のためのテスト・メソッド。
     */
    public void testGetOrderList() {
        createOrder();
        List<Order> order = conditionResultImpl.getOrderList();
        assertEquals(column1, order.get(0).getColumn());
        assertEquals(true, order.get(0).isAsc());

        assertEquals(column2, order.get(1).getColumn());
        assertEquals(false, order.get(1).isAsc());

    }

    private void createOrder() {
        conditionResultImpl.addOrder(column1, true);
        conditionResultImpl.addOrder(column2, false);
    }

}