/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.unit;

import java.io.File;

import junit.framework.AssertionFailedError;

import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.dataset.DataTable;

public class AbstractCodeGenExtensionTestCase extends CodeGenTestCaseExtension {

    public AbstractCodeGenExtensionTestCase(String name) {
        super(name);
    }

    private File testassertEquals_1;

    private File testassertEquals_2;

    protected void setUp() throws Exception {
        include("j2ee.dicon");
        // testassertEquals_1 = new File(ResourceUtil.getBuildDir(
        // TestCodeGenTestCaseExtension.class).getParent()
        // + "/" + "S2TestCaseExtensionTest_testassertEquals_1.xls");
        // testassertEquals_1.delete();
        // testassertEquals_2 = new File(ResourceUtil.getBuildDir(
        // TestCodeGenTestCaseExtension.class).getParent()
        // + "/" + "S2TestCaseExtensionTest_testassertEquals_2.xls");
        // testassertEquals_2.delete();

    }

    public void testassertEquals() throws Exception {
        DataSet expectSet = readXls("testDb.xls");
        DataTable expect = expectSet.getTable("DEPT_TABLE");
        DataTable actualSet = readDbByTable("DEPT_TABLE");

        try {
            assertEquals(expect, actualSet);
            fail();
        } catch (AssertionFailedError e) {
            // testassertEquals_1 = new File(ResourceUtil.getBuildDir(
            // S2TestCaseExtensionTest.class).getParent()
            // + "/" + "S2TestCaseExtensionTest_testassertEquals_1.xls");
            // testassertEquals_2 = new File(ResourceUtil.getBuildDir(
            // S2TestCaseExtensionTest.class).getParent()
            // + "/" + "S2TestCaseExtensionTest_testassertEquals_2.xls");
            // assertTrue(testassertEquals_1.exists());
            // assertFalse(testassertEquals_2.exists());
        }
        try {
            assertEquals(expect, actualSet);
            fail();
        } catch (AssertionFailedError e) {
            // assertTrue(testassertEquals_1.exists());
            // assertTrue(testassertEquals_2.exists());

        }

    }

    public void testAssertEqualsPkNotMatch() throws Exception {
        try {
            assertTable("testDb2.xls", "DEPT_TABLE");
            fail();
        } catch (AssertionFailedError e) {
            // testassertEquals_1 = new File(ResourceUtil.getBuildDir(
            // S2TestCaseExtensionTest.class).getParent()
            // + "/" + "S2TestCaseExtensionTest_testassertEquals_1.xls");
            // testassertEquals_2 = new File(ResourceUtil.getBuildDir(
            // S2TestCaseExtensionTest.class).getParent()
            // + "/" + "S2TestCaseExtensionTest_testassertEquals_2.xls");
            // assertTrue(testassertEquals_1.exists());
            // assertFalse(testassertEquals_2.exists());
        }

    }

    public void testAssertTable() throws Exception {
        try {
            assertTable("DEPT_TABLE");
            fail();
        } catch (AssertionFailedError e) {
            // testassertEquals_1 = new File(ResourceUtil.getBuildDir(
            // S2TestCaseExtensionTest.class).getParent()
            // + "/" + "S2TestCaseExtensionTest_testassertEquals_1.xls");
            // testassertEquals_2 = new File(ResourceUtil.getBuildDir(
            // S2TestCaseExtensionTest.class).getParent()
            // + "/" + "S2TestCaseExtensionTest_testassertEquals_2.xls");
            // assertTrue(testassertEquals_1.exists());
            // assertFalse(testassertEquals_2.exists());
        }

    }
}
