/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package org.seasar.codegen.sample.condition;

import org.seasar.codegen.lib.Condition;
import org.seasar.codegen.lib.ConditionResult;
import org.seasar.codegen.lib.impl.ColumnImpl;
import org.seasar.codegen.lib.impl.ConditionResultImpl;
import org.seasar.dao.pager.DefaultPagerCondition;

/**
 * DEPT_TABLEテーブルに対する検索条件です。
 * @author S2Dao-CodeGen
 */
public class DeptTableCondition extends DefaultPagerCondition implements Condition {

	private static final long serialVersionUID = 1L;

	private String alias;

	protected ConditionResult conditionResult;

	/**
	 * コンストラクタです。
	 * 
	 * @param alias 表の別名
	 * @param conditionResult 検索条件
	 */
	DeptTableCondition(ConditionResult conditionResult,String alias) {
		this.alias = alias;
		this.conditionResult = conditionResult;
	}

	/**
	 * コンストラクタです。表の別名はテーブル名になります。
	 */
	public DeptTableCondition() {
		this.alias = "DEPT_TABLE";
		this.conditionResult = new ConditionResultImpl();
	}

	public ConditionResult getConditionResult() {
		return conditionResult;
	}


	/**
	 * 部署番号の検索条件を返します。
	 * @return 部署番号の検索条件
	 */
	public org.seasar.codegen.lib.impl.ConditionElementImpl<Integer> selectDeptId() {
		return new org.seasar.codegen.lib.impl.ConditionElementImpl<Integer>(conditionResult, new ColumnImpl(this.alias,"DEPT_ID", getClass()));
	}


	/**
	 * 部署名の検索条件を返します。
	 * @return 部署名の検索条件
	 */
	public org.seasar.codegen.lib.impl.StringConditionElementImpl<String> selectDname() {
		return new org.seasar.codegen.lib.impl.StringConditionElementImpl<String>(conditionResult, new ColumnImpl(this.alias,"DNAME", getClass()));
	}


	/**
	 * 位置の検索条件を返します。
	 * @return 位置の検索条件
	 */
	public org.seasar.codegen.lib.impl.StringConditionElementImpl<String> selectLoc() {
		return new org.seasar.codegen.lib.impl.StringConditionElementImpl<String>(conditionResult, new ColumnImpl(this.alias,"LOC", getClass()));
	}


	/**
	 * バージョン番号の検索条件を返します。
	 * @return バージョン番号の検索条件
	 */
	public org.seasar.codegen.lib.impl.ConditionElementImpl<Integer> selectVersionno() {
		return new org.seasar.codegen.lib.impl.ConditionElementImpl<Integer>(conditionResult, new ColumnImpl(this.alias,"VERSIONNO", getClass()));
	}


	/**
	 * 状態の検索条件を返します。
	 * @return 状態の検索条件
	 */
	public org.seasar.codegen.lib.impl.ConditionElementImpl<Boolean> selectActive() {
		return new org.seasar.codegen.lib.impl.ConditionElementImpl<Boolean>(conditionResult, new ColumnImpl(this.alias,"ACTIVE", getClass()));
	}



	public void addQuery(String query, Object... args) {
		conditionResult.addQuery(query, args);
	}

	@Override
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append(conditionResult.toString());
		sb.append("/offset=");
		sb.append(getOffset());
		sb.append("/limit=");
		sb.append(getLimit());
		return sb.toString();
	}

}
