/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.sample.entity;

import java.util.Set;
import java.util.HashSet;

/**
 * NO_PKテーブルのEntityです。
 * @author S2Dao-CodeGen
 */

@org.seasar.dao.annotation.tiger.Bean(table = "NO_PK", versionNoProperty = "versionno")
public abstract class AbstractNoPk {

	private Integer col1;
	private String col2;
	
	private Set<String> modifiedPropertySet = new HashSet<String>();

	/**
	 * カラム１を返します。
	 * @return カラム１
	 */
	@org.seasar.dao.annotation.tiger.Column("COL_1")
	public Integer getCol1() {
		return col1;
	}

	/**
	 * カラム１を設定します。
	 * @param col1 カラム１
	 */
	public void setCol1(Integer col1) {
		modifiedPropertySet.add("col1");
		this.col1 = col1;
	}

	/**
	 * カラム２を返します。
	 * @return カラム２
	 */
	@org.seasar.dao.annotation.tiger.Column("COL_2")
	public String getCol2() {
		return col2;
	}

	/**
	 * カラム２を設定します。
	 * @param col2 カラム２
	 */
	public void setCol2(String col2) {
		modifiedPropertySet.add("col2");
		this.col2 = col2;
	}


	/**
	 * setterが呼ばれたプロパティのセットを返します。
	 * @return settterが呼ばれたプロパティのセット
	 */
	public Set<String> getModifiedPropertyNames() {
		return this.modifiedPropertySet;
	}

	public String toString() {
		StringBuilder buff = new StringBuilder("[");
		buff.append("/col1=").append(col1);
		buff.append("/col2=").append(col2);
		buff.append("]");
		return buff.toString();
	}

}
