/*
 * Copyright 2004-2010 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.dbms;

import java.util.List;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;
import org.seasar.codegen.element.DataType;
import org.seasar.codegen.element.FieldSetting;
import org.seasar.codegen.impl.JavaDataTypeSelectHelperImpl;
import org.seasar.codegen.unit.util.AssertUtil;
import org.seasar.codegen.unit.util.CSVUtil;

@RunWith(Parameterized.class)
public class AbstractDbmsTest {

    private String columnSize;

    private String pointNumber;

    private String expected;

    private HSQL target = new HSQL();

    public AbstractDbmsTest(String columnSize, String pointNumber,
            String exptected) {
        super();
        this.columnSize = columnSize;
        this.pointNumber = pointNumber;
        this.expected = exptected;
    }

    @Before
    public void setup() {
        target.setLangSelectUtil(new JavaDataTypeSelectHelperImpl());
    }

    @Test
    public void getDECIMALメソッドででFieldSettingの入力に応じてDataTypeの設定が行われること()
            throws Exception {
        FieldSetting fieldSetting = new FieldSetting();
        fieldSetting.setColmnSize(Integer.parseInt(columnSize));
        fieldSetting.setPointNumber(Integer.parseInt(pointNumber));
        fieldSetting.setFieldDefault("");
        DataType dataType = target.getDECIMAL(fieldSetting);
        AssertUtil.assertDataType("", expected, dataType);
    }

    @Parameters
    public static List<String[]> getParamters() {
        return CSVUtil.readCSV("org/seasar/codegen/dbms/AbstractDbms.csv");
    }

}
