/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.util;

import org.seasar.framework.util.StringUtil;

public class IdentityUtil {

    private IdentityUtil() {
    }

    public static boolean isTrue(String s) {
        if ("yes".equalsIgnoreCase(s) || "true".equalsIgnoreCase(s)) {
            return true;
        } else {
            return false;
        }
    }

    public static boolean isSequenceConfig(String identitytype) {
        if (StringUtil.isEmpty(identitytype)) {
            return false;
        }
        return identitytype.equalsIgnoreCase("sequence");
    }

    public static boolean isIdentityConfig(String identitytype) {
        if (StringUtil.isEmpty(identitytype)) {
            return false;
        }
        return identitytype.equalsIgnoreCase("identity");
    }

}
