/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import javax.sql.DataSource;
import org.seasar.dao.CommandContext;
import org.seasar.dao.Node;
import org.seasar.dao.context.CommandContextImpl;
import org.seasar.dao.impl.AbstractSqlCommand;
import org.seasar.dao.parser.SqlParserImpl;
import org.seasar.dao.util.FetchHandlerUtil;
import org.seasar.extension.jdbc.StatementFactory;

public abstract class AbstractDynamicCommand
extends AbstractSqlCommand {
    private Node rootNode;
    private String[] argNames = new String[0];
    private Class[] argTypes = new Class[0];

    public AbstractDynamicCommand(DataSource dataSource, StatementFactory statementFactory) {
        super(dataSource, statementFactory);
    }

    public void setSql(String sql) {
        super.setSql(sql);
        this.rootNode = new SqlParserImpl(sql).parse();
    }

    public String[] getArgNames() {
        return this.argNames;
    }

    public void setArgNames(String[] argNames) {
        this.argNames = argNames;
    }

    public Class[] getArgTypes() {
        return this.argTypes;
    }

    public void setArgTypes(Class[] argTypes) {
        this.argTypes = argTypes;
    }

    protected CommandContext apply(Object[] args) {
        CommandContext ctx = this.createCommandContext(args);
        this.rootNode.accept(ctx);
        return ctx;
    }

    protected CommandContext createCommandContext(Object[] args) {
        CommandContextImpl ctx = new CommandContextImpl();
        if (args != null) {
            for (int i = 0; !(i >= args.length || i == args.length - 1 && args[i] != null && FetchHandlerUtil.isFetchHandler(args[i].getClass())); ++i) {
                Class<?> argType = null;
                if (i < this.argTypes.length) {
                    argType = this.argTypes[i];
                } else if (args[i] != null) {
                    argType = args[i].getClass();
                }
                if (i < this.argNames.length) {
                    ctx.addArg(this.argNames[i], args[i], argType);
                    continue;
                }
                ctx.addArg("$" + (i + 1), args[i], argType);
            }
        }
        return ctx;
    }
}

