/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.DtoMetaData;
import org.seasar.dao.RowCreator;
import org.seasar.dao.util.DaoNamingConventionUtil;
import org.seasar.dao.util.PropertyDescUtil;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.StringUtil;

public class RowCreatorImpl
implements RowCreator {
    public Object createRow(ResultSet rs, Map propertyCache, Class beanClass) throws SQLException {
        Object row = this.newBean(beanClass);
        Set columnNameSet = propertyCache.keySet();
        Iterator ite = columnNameSet.iterator();
        while (ite.hasNext()) {
            String columnName = (String)ite.next();
            PropertyType pt = (PropertyType)propertyCache.get(columnName);
            this.registerValue(rs, row, pt, columnName);
        }
        return row;
    }

    protected Object newBean(Class beanClass) {
        return ClassUtil.newInstance((Class)beanClass);
    }

    protected void registerValue(ResultSet rs, Object row, PropertyType pt, String name) throws SQLException {
        ValueType valueType = pt.getValueType();
        Object value = valueType.getValue(rs, name);
        PropertyDesc pd = pt.getPropertyDesc();
        pd.setValue(row, value);
    }

    public Map createPropertyCache(Set columnNames, BeanMetaData beanMetaData) throws SQLException {
        Map proprertyCache = this.newPropertyCache();
        this.setupPropertyCache(proprertyCache, columnNames, beanMetaData);
        return proprertyCache;
    }

    protected void setupPropertyCache(Map proprertyCache, Set columnNames, BeanMetaData beanMetaData) throws SQLException {
        for (int i = 0; i < beanMetaData.getPropertyTypeSize(); ++i) {
            PropertyType pt = beanMetaData.getPropertyType(i);
            if (!this.isTargetProperty(pt)) continue;
            this.setupPropertyCacheElement(proprertyCache, columnNames, pt);
        }
    }

    protected void setupPropertyCacheElement(Map proprertyCache, Set columnNames, PropertyType pt) throws SQLException {
        if (columnNames.contains(pt.getColumnName())) {
            proprertyCache.put(pt.getColumnName(), pt);
        } else if (columnNames.contains(pt.getPropertyName())) {
            proprertyCache.put(pt.getPropertyName(), pt);
        } else if (!pt.isPersistent()) {
            this.setupPropertyCacheNotPersistentElement(proprertyCache, columnNames, pt);
        }
    }

    protected void setupPropertyCacheNotPersistentElement(Map proprertyCache, Set columnNames, PropertyType pt) throws SQLException {
        Iterator iter = columnNames.iterator();
        while (iter.hasNext()) {
            String columnName = (String)iter.next();
            String columnName2 = StringUtil.replace((String)columnName, (String)"_", (String)"");
            if (!columnName2.equalsIgnoreCase(pt.getColumnName())) continue;
            proprertyCache.put(columnName, pt);
            break;
        }
    }

    public Map createPropertyCache(Set columnNames, DtoMetaData dtoMetaData) throws SQLException {
        Map proprertyCache = this.newPropertyCache();
        this.setupPropertyCache(proprertyCache, columnNames, dtoMetaData);
        return proprertyCache;
    }

    protected void setupPropertyCache(Map proprertyCache, Set columnNames, DtoMetaData dtoMetaData) throws SQLException {
        for (int i = 0; i < dtoMetaData.getPropertyTypeSize(); ++i) {
            PropertyType pt = dtoMetaData.getPropertyType(i);
            if (!this.isTargetProperty(pt)) continue;
            if (columnNames.contains(pt.getColumnName())) {
                proprertyCache.put(pt.getColumnName(), pt);
                continue;
            }
            if (columnNames.contains(pt.getPropertyName())) {
                proprertyCache.put(pt.getPropertyName(), pt);
                continue;
            }
            String possibleName = DaoNamingConventionUtil.fromPropertyNameToColumnName(pt.getPropertyName());
            if (!columnNames.contains(possibleName)) continue;
            proprertyCache.put(possibleName, pt);
        }
    }

    protected Map newPropertyCache() {
        return new HashMap();
    }

    protected boolean isTargetProperty(PropertyType pt) throws SQLException {
        return PropertyDescUtil.isWritable(pt.getPropertyDesc());
    }
}

